/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command.parser;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.command.caption.OrbisCaptionKeys;
import org.empirewar.orbis.world.RegionisedWorld;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class RegionisedWorldParser<C>
implements ArgumentParser<C, RegionisedWorld>,
BlockingSuggestionProvider.Strings<C> {
    public @NonNull ArgumentParseResult<@NonNull RegionisedWorld> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        for (RegionisedWorld regionisedWorld : OrbisAPI.get().getRegionisedWorlds()) {
            if (!regionisedWorld.worldId().orElseThrow().asString().equalsIgnoreCase(input)) continue;
            commandInput.readString();
            return ArgumentParseResult.success((Object)regionisedWorld);
        }
        return ArgumentParseResult.failure((Throwable)((Object)new RegionisedWorldParserException(input, commandContext)));
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return OrbisAPI.get().getRegionisedWorlds().stream().map(rw -> rw.worldId().orElseThrow().asString()).toList();
    }

    public static final class RegionisedWorldParserException
    extends ParserException {
        private final String input;

        public RegionisedWorldParserException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(RegionisedWorldParser.class, context, OrbisCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD_NOT_FOUND, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

