/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.query;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.QueryResultBuilder;
import org.empirewar.orbis.query.RegionQueryFlagBuilder;
import org.empirewar.orbis.query.RegionQueryPositionBuilder;
import org.empirewar.orbis.region.Region;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public sealed interface RegionQuery<R> {
    public Result.Builder<? extends Result<R, ?>, R, ? extends RegionQuery<R>> resultBuilder();

    public static interface Result<R, Q extends RegionQuery<R>> {
        public Q query();

        public R result();

        public static <RQR extends Result<R, Q>, R, Q extends RegionQuery<R>> Builder<RQR, R, Q> builder(BiFunction<Q, R, RQR> transformer) {
            return new QueryResultBuilder<RQR, R, Q>(transformer);
        }

        public static <R, Q extends RegionQuery<R>> Builder<Result<R, Q>, R, Q> builder() {
            BiFunction<RegionQuery, Object, Result> function = (query, result) -> new Result<R, Q>((RegionQuery)query, result){
                final /* synthetic */ RegionQuery val$query;
                final /* synthetic */ Object val$result;
                {
                    this.val$query = regionQuery;
                    this.val$result = object;
                }

                @Override
                public Q query() {
                    return this.val$query;
                }

                @Override
                public R result() {
                    return this.val$result;
                }
            };
            return new QueryResultBuilder<Result, Object, RegionQuery>(function);
        }

        public static interface Builder<RQR extends Result<R, Q>, R, Q extends RegionQuery<R>> {
            public Builder<RQR, R, Q> query(Q var1);

            public Builder<RQR, R, Q> result(R var1);

            public RQR build();
        }
    }

    public static interface FilterableRegionResult<Q extends RegionQuery<Set<Region>>>
    extends Result<Set<Region>, Q>,
    Flag.Queryable {
        @Override
        default public <FR> Result<Optional<FR>, Flag<FR>> query(Flag<FR> flag) {
            Set regions = (Set)this.result();
            for (Region region : regions) {
                Result<Optional<FR>, Flag<FR>> query = region.query(flag);
                if (!query.result().isPresent()) continue;
                return query;
            }
            return Result.builder().query(flag).result(Optional.empty()).build();
        }

        public static <Q extends RegionQuery<Set<Region>>> Result.Builder<FilterableRegionResult<Q>, Set<Region>, Q> builder() {
            BiFunction<RegionQuery, Set, FilterableRegionResult> function = (query, result) -> new FilterableRegionResult<Q>((RegionQuery)query, (Set)result){
                final /* synthetic */ RegionQuery val$query;
                final /* synthetic */ Set val$result;
                {
                    this.val$query = regionQuery;
                    this.val$result = set;
                }

                @Override
                public Q query() {
                    return this.val$query;
                }

                @Override
                public Set<Region> result() {
                    return this.val$result;
                }
            };
            return new QueryResultBuilder<FilterableRegionResult, Set, RegionQuery>(function);
        }
    }

    public static interface Position
    extends RegionQuery<Set<Region>> {
        public Vector3dc position();

        @Override
        default public Result.Builder<FilterableRegionResult<Position>, Set<Region>, Position> resultBuilder() {
            return FilterableRegionResult.builder();
        }

        public static Builder builder() {
            return new RegionQueryPositionBuilder();
        }

        public static Builder at(Vector3dc position) {
            return Position.builder().position(position);
        }

        public static Builder at(double x, double y, double z) {
            return Position.builder().position(x, y, z);
        }

        public static sealed interface Builder
        permits RegionQueryPositionBuilder {
            public Builder position(Vector3dc var1);

            default public Builder position(double x, double y, double z) {
                return this.position((Vector3dc)new Vector3d(x, y, z));
            }

            public Position build();
        }

        public static interface Queryable {
            public FilterableRegionResult<Position> query(Position var1);

            default public FilterableRegionResult<Position> query(Builder position) {
                return this.query(position.build());
            }
        }
    }

    public static interface Flag<FR>
    extends RegionQuery<Optional<FR>> {
        public RegistryRegionFlag<FR> flag();

        public Optional<UUID> player();

        @Override
        default public Result.Builder<Result<Optional<FR>, Flag<FR>>, Optional<FR>, Flag<FR>> resultBuilder() {
            return Result.builder();
        }

        public static <FR> Builder<FR> builder() {
            return new RegionQueryFlagBuilder();
        }

        public static <FR> Builder<FR> builder(RegistryRegionFlag<FR> flag) {
            return new RegionQueryFlagBuilder<FR>().flag(flag);
        }

        public static sealed interface Builder<FR>
        permits RegionQueryFlagBuilder {
            public Builder<FR> flag(RegistryRegionFlag<FR> var1);

            public Builder<FR> player(UUID var1);

            public Flag<FR> build();
        }

        public static interface Queryable {
            public <FR> Result<Optional<FR>, Flag<FR>> query(Flag<FR> var1);

            default public <FR> Result<Optional<FR>, Flag<FR>> query(Builder<FR> flag) {
                return this.query(flag.build());
            }
        }
    }
}

