/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.selection;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.empirewar.orbis.area.Area;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.area.PolyhedralArea;
import org.empirewar.orbis.area.SphericalArea;
import org.empirewar.orbis.exception.IncompleteAreaException;
import org.empirewar.orbis.util.OrbisText;
import org.joml.Vector3ic;

public final class Selection {
    private static final Component RESET_LORE = ((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).build();
    public static final Component WAND_NAME = Component.text((String)"Orbis Wand", (TextColor)OrbisText.MAIN);
    public static final List<Component> WAND_LORE = List.of(RESET_LORE.append((Component)Component.text((String)"Left-Click", (TextColor)OrbisText.EREBOR_GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})).append((Component)Component.text((String)" to add a point.", (TextColor)OrbisText.EREBOR_GREEN)), RESET_LORE.append((Component)Component.text((String)"Right-Click", (TextColor)OrbisText.SECONDARY_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})).append((Component)Component.text((String)" to remove the last added point.", (TextColor)OrbisText.SECONDARY_RED)));
    private AreaType<?> selectionType;
    private final Set<Vector3ic> points;

    public Selection(AreaType<?> selectionType) {
        this.selectionType = selectionType;
        this.points = new LinkedHashSet<Vector3ic>();
    }

    public AreaType<?> getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(AreaType<?> selectionType) {
        this.selectionType = selectionType;
    }

    public Set<Vector3ic> getPoints() {
        return Set.copyOf(this.points);
    }

    public void addPoint(Vector3ic point) {
        this.points.add(point);
    }

    public void removePoint(Vector3ic point) {
        this.points.remove(point);
    }

    public void clear() {
        this.points.clear();
    }

    public Area build() throws IncompleteAreaException {
        EncompassingArea area = this.selectionType == AreaType.CUBOID ? new CuboidArea() : (this.selectionType == AreaType.POLYHEDRAL ? new PolyhedralArea() : (this.selectionType == AreaType.SPHERE ? new SphericalArea() : new PolygonArea()));
        Optional<Integer> max = area.getMaximumPoints();
        int min = area.getMinimumPoints();
        if (max.isPresent() && this.points.size() > max.get()) {
            throw new IncompleteAreaException("Expected at most " + String.valueOf(max.get()) + " points, but got " + this.points.size());
        }
        if (this.points.size() < min) {
            throw new IncompleteAreaException("Expected at least " + min + " points, but got " + this.points.size());
        }
        this.points.forEach(area::addPoint);
        return area;
    }
}

