/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.listener;

import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;

public abstract class InteractEntityListener
implements Listener {
    protected final OrbisBukkitPlatform<?> orbis;

    public InteractEntityListener(OrbisBukkitPlatform<?> orbis) {
        this.orbis = orbis;
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.shouldPreventEntityAction(entity, DefaultFlags.FALL_DAMAGE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMobDirectDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!(damager instanceof Player) && this.shouldPreventEntityAction(entity, DefaultFlags.CAN_TAKE_MOB_DAMAGE_SOURCES)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (this.shouldPreventEntityAction((Entity)player, DefaultFlags.CAN_DROP_ITEM)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent event) {
        if (this.shouldPreventEntityAction((Entity)event.getEntity(), DefaultFlags.CAN_PICKUP_ITEM)) {
            event.setCancelled(true);
        }
    }

    protected boolean shouldPreventEntityAction(Entity entity, RegistryRegionFlag<Boolean> flag) {
        return this.shouldPreventEntityAction(entity, entity, flag);
    }

    protected boolean shouldPreventEntityAction(Entity entity, @Nullable Entity player, RegistryRegionFlag<Boolean> flag) {
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)entity.getWorld()));
        if (world == null) {
            return false;
        }
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.getUniqueId());
        }
        Location location = entity.getLocation();
        return world.query(RegionQuery.Position.builder().position(location.getX(), location.getY(), location.getZ())).query(builder).result().orElse(true) == false;
    }
}

