/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.listener;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.paper.api.event.RegionEnterEvent;
import org.empirewar.orbis.paper.api.event.RegionLeaveEvent;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;

public record RegionTimeListener(Orbis orbis) implements Listener
{
    @EventHandler
    public void onEnter(RegionEnterEvent event) {
        Player player = event.getPlayer();
        Location location = event.getLocation();
        RegionisedWorld world = event.getWorld();
        this.applyTimeChanges(player, world, location.getX(), location.getY(), location.getZ());
    }

    @EventHandler
    public void onLeave(RegionLeaveEvent event) {
        Player player = event.getPlayer();
        Location location = event.getLocation();
        RegionisedWorld world = event.getWorld();
        this.applyTimeChanges(player, world, location.getX(), location.getY(), location.getZ());
    }

    private void applyTimeChanges(Player player, RegionisedWorld world, double x, double y, double z) {
        Optional<Long> timeResult = world.query(RegionQuery.Position.at(x, y, z).build()).query(RegionQuery.Flag.builder(DefaultFlags.TIME).player(player.getUniqueId())).result();
        timeResult.ifPresentOrElse(time -> player.setPlayerTime(time.longValue(), false), () -> ((Player)player).resetPlayerTime());
    }
}

