/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.selection;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public record SelectionListener(OrbisBukkitPlatform<?> api) implements Listener
{
    @EventHandler
    public void onLeftRightClick(PlayerInteractEvent event) {
        Vector3i point;
        Player player = event.getPlayer();
        if (!player.hasPermission("orbis.manage")) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !this.api.isWand(item)) {
            return;
        }
        Audience audience = this.api.senderAsAudience((CommandSender)player);
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) {
            Selection selection = this.api.selectionManager().get(player.getUniqueId()).orElse(null);
            if (selection == null) {
                audience.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_NOT_ACTIVE));
                return;
            }
            Vector3ic last = selection.getPoints().stream().reduce((first, second) -> second).orElse(null);
            if (last == null) {
                return;
            }
            selection.removePoint(last);
            audience.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_REMOVED));
            return;
        }
        Selection selection = this.api.selectionManager().get(player.getUniqueId()).orElseGet(() -> {
            Selection newSelection = new Selection(AreaType.CUBOID);
            this.api.selectionManager().add(player.getUniqueId(), newSelection);
            audience.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Started a new cuboid selection.", (TextColor)OrbisText.EREBOR_GREEN)));
            return newSelection;
        });
        Block block = event.getClickedBlock();
        if (block == null || block.getType().isAir()) {
            Location blockPos = player.getLocation();
            point = new Vector3i(blockPos.getBlockX(), blockPos.getBlockY(), blockPos.getBlockZ());
        } else {
            point = new Vector3i(block.getX(), block.getY(), block.getZ());
        }
        event.setCancelled(true);
        selection.addPoint((Vector3ic)point);
        player.sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_ADDED.arguments(new ComponentLike[]{Component.text((int)point.x), Component.text((int)point.y), Component.text((int)point.z)})).hoverEvent((HoverEventSource)HoverEvent.showText((Component)OrbisTranslations.GENERIC_CLICK_TO_TELEPORT)).clickEvent(ClickEvent.callback(u -> player.teleport(new Location(player.getWorld(), (double)point.x, (double)point.y, (double)point.z, player.getLocation().getYaw(), player.getLocation().getPitch())), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(3L)).build()))));
    }
}

