/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.migrations.rpgregions;

import net.islandearth.rpgregions.api.IRPGRegionsAPI;
import net.islandearth.rpgregions.api.RPGRegionsAPI;
import net.islandearth.rpgregions.api.integrations.IntegrationManager;
import net.islandearth.rpgregions.api.integrations.rpgregions.RPGRegionsIntegration;
import net.islandearth.rpgregions.api.integrations.rpgregions.region.PolyRegion;
import net.islandearth.rpgregions.api.integrations.rpgregions.region.RPGRegionsRegion;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.area.CuboidArea;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.world.RegionisedWorld;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class RPGRegionsMigrator {
    public RPGRegionsMigrator(Audience actor) {
        Audience audience = Audience.audience((Audience[])new Audience[]{actor, Bukkit.getConsoleSender()});
        IRPGRegionsAPI api = RPGRegionsAPI.getAPI();
        IntegrationManager integrationManager = api.getManagers().getIntegrationManager();
        if (!(integrationManager instanceof RPGRegionsIntegration)) {
            audience.sendMessage((Component)Component.text((String)"The RPGRegions integration is not the default one.", (TextColor)NamedTextColor.RED));
            return;
        }
        RPGRegionsIntegration integration = (RPGRegionsIntegration)integrationManager;
        int worldIndex = 1;
        for (World world : Bukkit.getWorlds()) {
            audience.sendMessage((Component)Component.text((String)("Processing worlds (" + worldIndex + "/" + Bukkit.getWorlds().size() + "): " + world.getName()), (TextColor)NamedTextColor.GREEN));
            RegionisedWorld regionisedWorld = OrbisAPI.get().getRegionisedWorld(world.key());
            for (RPGRegionsRegion region : integration.getRegions()) {
                if (!region.getWorld().equals(world.getUID())) continue;
                audience.sendMessage((Component)Component.text((String)("Processing region " + region.getName() + "..."), (TextColor)NamedTextColor.YELLOW));
                EncompassingArea area = region instanceof PolyRegion ? new PolygonArea() : new CuboidArea();
                for (Location point : region.getPoints()) {
                    area.addPoint((Vector3ic)new Vector3i(point.blockX(), point.blockY(), point.blockZ()));
                }
                Region orbisRegion = new Region(region.getName(), area);
                orbisRegion.priority(region.getPriority());
                regionisedWorld.add(orbisRegion);
                OrbisRegistries.REGIONS.register(orbisRegion.key(), orbisRegion);
                audience.sendMessage((Component)Component.text((String)("Added region '" + orbisRegion.name() + "'."), (TextColor)NamedTextColor.GREEN));
            }
            ++worldIndex;
        }
        audience.sendMessage((Component)Component.text((String)"Migration complete.", (TextColor)NamedTextColor.GREEN));
        audience.sendMessage((Component)Component.text((String)"What's next?", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        audience.sendMessage((Component)Component.text((String)" 1) Stop your server.", (TextColor)NamedTextColor.GRAY));
        audience.sendMessage((Component)Component.text((String)" 2) Change the RPGRegions integration to Orbis.", (TextColor)NamedTextColor.GRAY));
        audience.sendMessage((Component)Component.text((String)" 3) Start your server again. Welcome to Orbis!", (TextColor)NamedTextColor.GRAY));
    }
}

