/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper;

import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.empirewar.orbis.bukkit.listener.BlockActionListener;
import org.empirewar.orbis.bukkit.listener.ConnectionListener;
import org.empirewar.orbis.bukkit.listener.EntityDamageListener;
import org.empirewar.orbis.bukkit.listener.MovementListener;
import org.empirewar.orbis.bukkit.listener.RegionTimeListener;
import org.empirewar.orbis.bukkit.selection.SelectionListener;
import org.empirewar.orbis.paper.OrbisPaperPlatform;
import org.empirewar.orbis.paper.listener.InteractEntityExtensionListener;
import org.empirewar.orbis.paper.listener.RegionMessagesListener;

public class OrbisPaper
extends JavaPlugin
implements Listener {
    private final OrbisPaperPlatform platform = new OrbisPaperPlatform(this);

    public void onEnable() {
        this.platform.onEnable();
        this.registerListeners();
        try {
            this.platform.loadRegions();
        }
        catch (IOException e) {
            this.platform.logger().error("Error loading regions", (Throwable)e);
        }
        Bukkit.getWorlds().forEach(w -> this.platform.loadWorld(w.key(), w.getUID()));
    }

    public void onDisable() {
        try {
            this.platform.saveRegions();
        }
        catch (IOException e) {
            this.platform.logger().error("Error saving regions", (Throwable)e);
        }
    }

    @EventHandler
    public void onLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        this.platform.loadWorld(world.key(), world.getUID());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        this.platform.saveWorld(world.key(), world.getUID());
    }

    private void registerListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockActionListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new InteractEntityExtensionListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new MovementListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new RegionTimeListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new ConnectionListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new SelectionListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityDamageListener(this.platform), (Plugin)this);
        pluginManager.registerEvents((Listener)new RegionMessagesListener(this.platform), (Plugin)this);
    }
}

