/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.bootstrap;

import com.mojang.brigadier.Message;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.empirewar.orbis.bukkit.command.BukkitCommands;
import org.empirewar.orbis.paper.libs.cloud.SenderMapper;
import org.empirewar.orbis.paper.libs.cloud.brigadier.suggestion.TooltipSuggestion;
import org.empirewar.orbis.paper.libs.cloud.execution.ExecutionCoordinator;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.empirewar.orbis.paper.libs.cloud.paper.PaperCommandManager;
import org.empirewar.orbis.paper.session.PaperConsoleSession;
import org.empirewar.orbis.paper.session.PaperPlayerSession;
import org.empirewar.orbis.player.OrbisSession;

public class OrbisPluginBootstrap
implements PluginBootstrap {
    public void bootstrap(BootstrapContext bootstrapContext) {
        SenderMapper<CommandSourceStack, OrbisSession> mapper = SenderMapper.create(source -> {
            Entity patt0$temp = source.getExecutor();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                return new PaperPlayerSession(player, (CommandSourceStack)source);
            }
            return new PaperConsoleSession((CommandSender)Bukkit.getConsoleSender(), (CommandSourceStack)source);
        }, session -> {
            if (session instanceof PaperPlayerSession) {
                PaperPlayerSession paper = (PaperPlayerSession)session;
                return paper.source();
            }
            return ((PaperConsoleSession)session).source();
        });
        PaperCommandManager.Bootstrapped<OrbisSession> manager = PaperCommandManager.builder(mapper).executionCoordinator(ExecutionCoordinator.simpleCoordinator()).buildBootstrapped(bootstrapContext);
        manager.appendSuggestionMapper(suggestion -> {
            if (!(suggestion instanceof ComponentTooltipSuggestion)) {
                return suggestion;
            }
            ComponentTooltipSuggestion componentTooltipSuggestion = (ComponentTooltipSuggestion)suggestion;
            return TooltipSuggestion.suggestion(suggestion.suggestion(), (Message)MessageComponentSerializer.message().serializeOrNull(componentTooltipSuggestion.tooltip()));
        });
        new BukkitCommands<PaperCommandManager.Bootstrapped<OrbisSession>>(manager);
    }
}

