/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.bukkit;

import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitCommandContextKeys;
import org.empirewar.orbis.paper.libs.cloud.bukkit.BukkitCommandManager;
import org.empirewar.orbis.paper.libs.cloud.bukkit.CloudBukkitCapabilities;
import org.empirewar.orbis.paper.libs.cloud.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import org.empirewar.orbis.paper.libs.cloud.bukkit.internal.BukkitHelper;
import org.empirewar.orbis.paper.libs.cloud.execution.preprocessor.CommandPreprocessingContext;
import org.empirewar.orbis.paper.libs.cloud.execution.preprocessor.CommandPreprocessor;

final class BukkitCommandPreprocessor<C>
implements CommandPreprocessor<C> {
    private final BukkitCommandManager<C> commandManager;
    private final @Nullable BukkitBackwardsBrigadierSenderMapper<C, ?> mapper;

    BukkitCommandPreprocessor(@NonNull BukkitCommandManager<C> commandManager) {
        this.commandManager = commandManager;
        this.mapper = this.commandManager.hasCapability(CloudBukkitCapabilities.BRIGADIER) ? new BukkitBackwardsBrigadierSenderMapper(this.commandManager.senderMapper()) : null;
    }

    @Override
    public void accept(@NonNull CommandPreprocessingContext<C> context) {
        if (this.mapper != null && !context.commandContext().contains("_cloud_brigadier_native_sender")) {
            context.commandContext().store("_cloud_brigadier_native_sender", this.mapper.apply(context.commandContext().sender()));
        }
        context.commandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, this.commandManager.senderMapper().reverse(context.commandContext().sender()));
        context.commandContext().computeIfAbsent(BukkitCommandContextKeys.SENDER_SCHEDULER_EXECUTOR, $ -> BukkitHelper.mainThreadExecutor(this.commandManager));
    }
}

