/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.rtree;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.empirewar.orbis.paper.libs.rtree.Entry;
import org.empirewar.orbis.paper.libs.rtree.ImageSaver;
import org.empirewar.orbis.paper.libs.rtree.Leaf;
import org.empirewar.orbis.paper.libs.rtree.Node;
import org.empirewar.orbis.paper.libs.rtree.NonLeaf;
import org.empirewar.orbis.paper.libs.rtree.RTree;
import org.empirewar.orbis.paper.libs.rtree.RectangleDepth;
import org.empirewar.orbis.paper.libs.rtree.geometry.Geometry;
import org.empirewar.orbis.paper.libs.rtree.geometry.Rectangle;
import org.empirewar.orbis.paper.libs.rtree.guava.Preconditions;

public final class Visualizer {
    private final RTree<?, Geometry> tree;
    private final int width;
    private final int height;
    private final Rectangle view;
    private final int maxDepth;

    Visualizer(RTree<?, Geometry> tree, int width, int height, Rectangle view) {
        Preconditions.checkArgument(tree.dimensions() == 2, "visualizer only supported for 2 dimensions");
        this.tree = tree;
        this.width = width;
        this.height = height;
        this.view = view;
        this.maxDepth = Visualizer.calculateMaxDepth(tree.root());
    }

    private static <R, S extends Geometry> int calculateMaxDepth(Optional<? extends Node<R, S>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return Visualizer.calculateDepth(root.get(), 0);
    }

    private static <R, S extends Geometry> int calculateDepth(Node<R, S> node, int depth) {
        if (node.isLeaf()) {
            return depth + 1;
        }
        return Visualizer.calculateDepth(((NonLeaf)node).child(0), depth + 1);
    }

    public BufferedImage createImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setBackground(Color.white);
        g2.clearRect(0, 0, this.width, this.height);
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        if (this.tree.root().isPresent()) {
            List<RectangleDepth> nodeDepths = this.getNodeDepthsSortedByDepth(this.tree.root().get());
            this.drawNode(g2, nodeDepths);
        }
        return image;
    }

    private <T, S extends Geometry> List<RectangleDepth> getNodeDepthsSortedByDepth(Node<T, S> root) {
        List<RectangleDepth> list = this.getRectangleDepths(root, 0);
        Collections.sort(list, new Comparator<RectangleDepth>(){

            @Override
            public int compare(RectangleDepth n1, RectangleDepth n2) {
                return Integer.valueOf(n1.getDepth()).compareTo(n2.getDepth());
            }
        });
        return list;
    }

    private <T, S extends Geometry> List<RectangleDepth> getRectangleDepths(Node<T, S> node, int depth) {
        ArrayList<RectangleDepth> list = new ArrayList<RectangleDepth>();
        list.add(new RectangleDepth(node.geometry().mbr(), depth));
        if (node.isLeaf()) {
            Leaf leaf = (Leaf)node;
            for (Entry entry : leaf.entries()) {
                list.add(new RectangleDepth(entry.geometry().mbr(), depth + 2));
            }
        } else {
            NonLeaf n = (NonLeaf)node;
            for (int i = 0; i < n.count(); ++i) {
                list.addAll(this.getRectangleDepths(n.child(i), depth + 1));
            }
        }
        return list;
    }

    private void drawNode(Graphics2D g2, List<RectangleDepth> nodes) {
        for (RectangleDepth node : nodes) {
            Color color = Color.getHSBColor((float)node.getDepth() / ((float)this.maxDepth + 1.0f), 1.0f, 1.0f);
            g2.setStroke(new BasicStroke(Math.max(0.5f, (float)(this.maxDepth - node.getDepth() + 1 - 1))));
            g2.setColor(color);
            Rectangle r = node.getRectangle();
            this.drawRectangle(g2, r);
        }
    }

    private void drawRectangle(Graphics2D g2, Rectangle r) {
        double x1 = (r.min(0) - this.view.min(0)) / (this.view.max(0) - this.view.min(0)) * (double)this.width;
        double y1 = (r.min(1) - this.view.min(1)) / (this.view.max(1) - this.view.min(1)) * (double)this.height;
        double x2 = (r.max(0) - this.view.min(0)) / (this.view.max(0) - this.view.min(0)) * (double)this.width;
        double y2 = (r.max(1) - this.view.min(1)) / (this.view.max(1) - this.view.min(1)) * (double)this.height;
        g2.drawRect(Visualizer.rnd(x1), Visualizer.rnd(y1), Math.max(Visualizer.rnd(x2 - x1), 1), Math.max(Visualizer.rnd(y2 - y1), 1));
    }

    private static int rnd(double d) {
        return (int)Math.round(d);
    }

    public void save(File file, String imageFormat) {
        ImageSaver.save(this.createImage(), file, imageFormat);
    }

    public void save(String filename, String imageFormat) {
        this.save(new File(filename), imageFormat);
    }

    public void save(String filename) {
        this.save(new File(filename), "PNG");
    }
}

