/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.rtree.guava;

public final class Optional<T> {
    private final T value;
    private final boolean present;

    private Optional(T value, boolean present) {
        this.value = value;
        this.present = present;
    }

    private Optional() {
        this(null, false);
    }

    public boolean isPresent() {
        return this.present;
    }

    public T get() {
        if (this.present) {
            return this.value;
        }
        throw new NotPresentException();
    }

    public T or(T alternative) {
        if (this.present) {
            return this.value;
        }
        return alternative;
    }

    public static <T> Optional<T> fromNullable(T t2) {
        if (t2 == null) {
            return Optional.absent();
        }
        return Optional.of(t2);
    }

    public static <T> Optional<T> of(T t2) {
        return new Optional<T>(t2, true);
    }

    public static <T> Optional<T> absent() {
        return new Optional<T>();
    }

    public String toString() {
        return this.present ? String.format("Optional.of(%s)", this.value) : "Optional.absent";
    }

    public static class NotPresentException
    extends RuntimeException {
        private static final long serialVersionUID = -4444814681271790328L;
    }
}

