/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.listener;

import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.bukkit.listener.InteractEntityListener;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;

public class InteractEntityExtensionListener
extends InteractEntityListener {
    public InteractEntityExtensionListener(OrbisBukkitPlatform<?> orbis) {
        super(orbis);
    }

    @EventHandler
    public void onAttackDirect(PrePlayerAttackEntityEvent event) {
        RegionQuery.Flag.Builder<Object> flagQueryBuilder;
        RegistryRegionFlag<Boolean> flag;
        if (!event.willAttack()) {
            return;
        }
        Entity attacked = event.getAttacked();
        Player attacker = event.getPlayer();
        RegionisedWorld world = this.orbis.getRegionisedWorld(attacked.getWorld().key());
        RegionQuery.FilterableRegionResult<RegionQuery.Position> positionQuery = world.query(RegionQuery.Position.at(attacked.getX(), attacked.getY(), attacked.getZ()));
        Entity entity = attacked;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Vehicle.class, Painting.class, ItemFrame.class}, (Object)entity2, n)) {
            case 0: {
                Vehicle ignored = (Vehicle)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_VEHICLE;
                break;
            }
            case 1: {
                Painting ignored = (Painting)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_PAINTING;
                break;
            }
            case 2: {
                ItemFrame ignored = (ItemFrame)entity2;
                RegistryRegionFlag<Boolean> registryRegionFlag = DefaultFlags.CAN_DESTROY_ITEM_FRAME;
                break;
            }
            default: {
                RegistryRegionFlag<Boolean> registryRegionFlag = flag = null;
            }
        }
        if (flag != null) {
            flagQueryBuilder = RegionQuery.Flag.builder(flag).player(attacker.getUniqueId());
            if (!positionQuery.query(flagQueryBuilder).result().orElse(true).booleanValue()) {
                event.setCancelled(true);
            }
            return;
        }
        if (!attacked.getType().isAlive()) {
            return;
        }
        if (attacked instanceof Player) {
            if (this.orbis.config().node(new Object[]{"cancel-pvp-hit-sounds"}).getBoolean(true) && this.shouldPreventEntityAction(attacked, (Entity)attacker, DefaultFlags.CAN_PVP)) {
                event.setCancelled(true);
            }
            return;
        }
        flagQueryBuilder = RegionQuery.Flag.builder(DefaultFlags.DAMAGEABLE_ENTITIES).player(attacker.getUniqueId());
        List damageable = positionQuery.query(flagQueryBuilder).result().orElse(null);
        if (damageable == null) {
            return;
        }
        if (!damageable.contains(attacked.getType().key())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent event) {
        if (this.orbis.config().node(new Object[]{"cancel-pvp-hit-sounds"}).getBoolean(true)) {
            return;
        }
        Entity attacked = event.getEntity();
        if (attacked instanceof Player && event.getDamager() instanceof Player && this.shouldPreventEntityAction(attacked, event.getDamager(), DefaultFlags.CAN_PVP)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRotate(PlayerItemFrameChangeEvent event) {
        if (event.getAction() == PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE) {
            if (this.shouldPreventEntityAction((Entity)event.getItemFrame(), (Entity)event.getPlayer(), DefaultFlags.ITEM_FRAME_ROTATE)) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE && this.shouldPreventEntityAction((Entity)event.getItemFrame(), (Entity)event.getPlayer(), DefaultFlags.ITEM_FRAME_ITEM_PLACE)) {
            event.setCancelled(true);
        }
    }
}

