/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.command;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.command.HelpCommands;
import org.empirewar.orbis.command.RegionCommand;
import org.empirewar.orbis.command.SelectionCommand;
import org.empirewar.orbis.command.caption.OrbisCaptionProvider;
import org.empirewar.orbis.command.parser.FlagValueParser;
import org.empirewar.orbis.command.parser.RegionFlagParser;
import org.empirewar.orbis.command.parser.RegionisedWorldParser;
import org.empirewar.orbis.command.parser.registry.RegistryMapper;
import org.empirewar.orbis.command.parser.registry.RegistryValueParser;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.flag.value.FlagValue;
import org.empirewar.orbis.member.MemberType;
import org.empirewar.orbis.player.OrbisSession;
import org.empirewar.orbis.player.PlayerOrbisSession;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.region.Region;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.world.RegionisedWorld;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.processors.cache.CaffeineCache;
import org.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import org.incendo.cloud.processors.confirmation.ConfirmationManager;
import org.incendo.cloud.processors.confirmation.ImmutableConfirmationConfiguration;

public final class CommonCommands {
    public CommonCommands(CommandManager<OrbisSession> manager) {
        ImmutableConfirmationConfiguration confirmationConfig = ConfirmationConfiguration.builder().cache(CaffeineCache.of((Cache)Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build())).noPendingCommandNotifier(sender -> sender.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"You don't have any pending confirmations.", (TextColor)OrbisText.SECONDARY_RED)))).confirmationRequiredNotifier((sender, context) -> sender.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Confirmation required. Confirm using /confirm.", (TextColor)OrbisText.SECONDARY_ORANGE)))).build();
        ConfirmationManager confirmationManager = ConfirmationManager.confirmationManager((ConfirmationConfiguration)confirmationConfig);
        manager.command(manager.commandBuilder("orbis", new String[0]).literal("confirm", new String[0]).handler(confirmationManager.createExecutionHandler()));
        manager.command(manager.commandBuilder("orbis", new String[0]).senderType(PlayerOrbisSession.class).permission("orbis.manage").literal("wand", new String[0]).handler(context -> {
            PlayerOrbisSession sender = (PlayerOrbisSession)context.sender();
            sender.giveWandItem();
            Selection.WAND_LORE.forEach(arg_0 -> ((PlayerOrbisSession)sender).sendMessage(arg_0));
        }));
        manager.command(manager.commandBuilder("orbis", new String[0]).permission("orbis.manage").senderType(PlayerOrbisSession.class).literal("where", new String[0]).handler(context -> {
            Orbis orbis = OrbisAPI.get();
            PlayerOrbisSession sender = (PlayerOrbisSession)context.sender();
            Key playerWorld = orbis.getPlayerWorld(sender.getUuid());
            RegionisedWorld world = orbis.getRegionisedWorld(playerWorld);
            sender.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)("You are in world " + world.worldId().orElseThrow().asString() + "."), (TextColor)OrbisText.SECONDARY_ORANGE)));
            for (Region region : (Set)world.query(RegionQuery.Position.at(sender.getPosition()).build()).result()) {
                sender.sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)("You are in region " + region.name() + "."), (TextColor)OrbisText.EREBOR_GREEN)));
            }
        }));
        manager.registerCommandPostProcessor(confirmationManager.createPostprocessor());
        manager.captionRegistry().registerProvider(new OrbisCaptionProvider());
        manager.parserRegistry().registerParserSupplier(TypeToken.get(RegionisedWorld.class), parserParameters -> new RegionisedWorldParser());
        TypeToken typeToken = TypeToken.get((Type)TypeFactory.parameterizedClass(RegistryRegionFlag.class, (Type[])new Type[]{TypeFactory.unboundWildcard()}));
        manager.parserRegistry().registerParserSupplier(typeToken, parserParameters -> new RegionFlagParser());
        TypeToken flagValueToken = TypeToken.get((Type)TypeFactory.parameterizedClass(FlagValue.class, (Type[])new Type[]{TypeFactory.unboundWildcard()}));
        manager.parserRegistry().registerParserSupplier(flagValueToken, parserParameters -> new FlagValueParser(manager));
        TypeToken areaTypeToken = TypeToken.get((Type)TypeFactory.parameterizedClass(AreaType.class, (Type[])new Type[]{TypeFactory.unboundWildcard()}));
        manager.parserRegistry().registerParserSupplier(areaTypeToken, parserParameters -> new RegistryValueParser(OrbisRegistries.AREA_TYPE, RegistryMapper.KEY));
        TypeToken memberTypeToken = TypeToken.get((Type)TypeFactory.parameterizedClass(MemberType.class, (Type[])new Type[]{TypeFactory.unboundWildcard()}));
        manager.parserRegistry().registerParserSupplier(memberTypeToken, parserParameters -> new RegistryValueParser(OrbisRegistries.MEMBER_TYPE, RegistryMapper.KEY));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(Region.class), parserParameters -> new RegistryValueParser(OrbisRegistries.REGIONS, RegistryMapper.IDENTITY));
        AnnotationParser annotationParser = new AnnotationParser(manager, OrbisSession.class);
        MinecraftExceptionHandler.create(OrbisSession::getAudience).defaultInvalidSyntaxHandler().defaultInvalidSenderHandler().defaultNoPermissionHandler().defaultArgumentParsingHandler().defaultCommandExecutionHandler().registerTo(manager);
        annotationParser.parse(new Object[]{new HelpCommands(manager)});
        annotationParser.parse(new Object[]{new RegionCommand()});
        annotationParser.parse(new Object[]{new SelectionCommand()});
    }
}

