/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge.listener;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.PistonEvent;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.modded.util.FlagActions;
import org.empirewar.orbis.neoforge.OrbisNeoForge;

public final class BlockActionListener {
    private final OrbisNeoForge orbis;

    public BlockActionListener(OrbisNeoForge orbis) {
        this.orbis = orbis;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (FlagActions.shouldPreventBlockAction((Level)event.getLevel(), event.getPos(), event.getPlayer(), DefaultFlags.CAN_BREAK)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FlagActions.shouldPreventBlockAction((Level)event.getLevel(), event.getPos(), player, DefaultFlags.CAN_PLACE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPistonPushPull(PistonEvent.Pre event) {
        PistonStructureResolver structureHelper = event.getStructureHelper();
        if (structureHelper == null) {
            return;
        }
        if (!structureHelper.resolve()) {
            return;
        }
        for (BlockPos toPush : structureHelper.getToPush()) {
            if (!FlagActions.shouldPreventBlockAction((Level)event.getLevel(), toPush, null, DefaultFlags.ACTIVATE_PISTONS)) continue;
            event.setCanceled(true);
            return;
        }
        for (BlockPos toDestroy : structureHelper.getToDestroy()) {
            if (!FlagActions.shouldPreventBlockAction((Level)event.getLevel(), toDestroy, null, DefaultFlags.ACTIVATE_PISTONS)) continue;
            event.setCanceled(true);
            return;
        }
    }
}

