/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.neoforge.selection;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.neoforge.OrbisNeoForge;
import org.empirewar.orbis.selection.Selection;
import org.empirewar.orbis.util.OrbisText;
import org.empirewar.orbis.util.OrbisTranslations;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class SelectionListener {
    private final Orbis api;

    public SelectionListener(Orbis api) {
        this.api = api;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (!((Boolean)PermissionAPI.getPermission((ServerPlayer)player, OrbisNeoForge.ORBIS_MANAGE, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
            return;
        }
        ItemStack item = player.getItemInHand(event.getHand());
        if (item.isEmpty() || !((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("orbis_is_wand")) {
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            return;
        }
        Selection selection = this.api.selectionManager().get(player.getUUID()).orElse(null);
        if (selection == null) {
            ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_NOT_ACTIVE));
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            return;
        }
        Vector3ic last = selection.getPoints().stream().reduce((first, second) -> second).orElse(null);
        if (last == null) {
            event.setCancellationResult((InteractionResult)InteractionResult.PASS);
            return;
        }
        selection.removePoint(last);
        ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_REMOVED));
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        if (this.handleLeftClick((ServerPlayer)event.getEntity(), event.getPos(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        this.handleLeftClick((ServerPlayer)event.getEntity(), event.getPos(), event.getHand());
    }

    private boolean handleLeftClick(ServerPlayer player, BlockPos blockPos, InteractionHand hand) {
        Vector3i point;
        if (!((Boolean)PermissionAPI.getPermission((ServerPlayer)player, OrbisNeoForge.ORBIS_MANAGE, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
            return false;
        }
        ItemStack item = player.getItemInHand(hand);
        if (item.isEmpty() || !((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("orbis_is_wand")) {
            return false;
        }
        Selection selection = this.api.selectionManager().get(player.getUUID()).orElseGet(() -> {
            Selection newSelection = new Selection(AreaType.CUBOID);
            this.api.selectionManager().add(player.getUUID(), newSelection);
            ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)Component.text((String)"Started a new cuboid selection.", (TextColor)OrbisText.EREBOR_GREEN)));
            return newSelection;
        });
        BlockState block = player.level().getBlockState(blockPos);
        if (block.isAir()) {
            BlockPos playerPos = player.blockPosition();
            point = new Vector3i(playerPos.getX(), playerPos.getY(), playerPos.getZ());
        } else {
            point = new Vector3i(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        }
        selection.addPoint((Vector3ic)point);
        ((Audience)player).sendMessage(OrbisText.PREFIX.append((Component)OrbisTranslations.SELECTION_POINT_ADDED.arguments(new ComponentLike[]{Component.text((int)point.x), Component.text((int)point.y), Component.text((int)point.z)})).hoverEvent((HoverEventSource)HoverEvent.showText((Component)OrbisTranslations.GENERIC_CLICK_TO_TELEPORT)).clickEvent(ClickEvent.callback(audience -> player.teleportTo((double)point.x, (double)point.y, (double)point.z), (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(3L)).build()))));
        return true;
    }
}

