/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.query;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiFunction;
import org.empirewar.orbis.query.RegionQuery;

final class QueryResultBuilder<RQR extends RegionQuery.Result<R, Q>, R, Q extends RegionQuery<R>>
implements RegionQuery.Result.Builder<RQR, R, Q> {
    private final BiFunction<Q, R, RQR> transformer;
    private R result;
    private Q query;

    QueryResultBuilder(BiFunction<Q, R, RQR> transformer) {
        this.transformer = transformer;
    }

    @Override
    public QueryResultBuilder<RQR, R, Q> query(Q query) {
        Objects.requireNonNull(query, "Query cannot be null");
        this.query = query;
        return this;
    }

    @Override
    public QueryResultBuilder<RQR, R, Q> result(R result) {
        Objects.requireNonNull(result, "Result cannot be null");
        this.result = result;
        return this;
    }

    @Override
    public RQR build() {
        Preconditions.checkState((this.query != null ? 1 : 0) != 0, (Object)"Query cannot be empty");
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Result cannot be empty");
        return (RQR)((RegionQuery.Result)this.transformer.apply(this.query, this.result));
    }
}

