/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.EncompassingArea;
import org.empirewar.orbis.util.ExtraCodecs;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class SphericalArea
extends EncompassingArea {
    public static final MapCodec<SphericalArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VEC_3I.fieldOf("center").forGetter(SphericalArea::getCenter), (App)Codec.DOUBLE.fieldOf("radius").forGetter(SphericalArea::getRadius)).apply((Applicative)instance, SphericalArea::new));
    private double radius;

    public SphericalArea() {
        this.radius = 5.0;
    }

    SphericalArea(Vector3ic point, double radius) {
        super(Collections.singletonList(point));
        this.radius = radius;
        this.calculateEncompassingArea();
    }

    @Override
    public boolean contains(Vector3dc point) {
        return this.contains(point.x(), point.y(), point.z());
    }

    @Override
    public boolean contains(double x, double y, double z) {
        double dz;
        double dy;
        Vector3ic center = this.getCenter();
        double dx = x - (double)center.x();
        return dx * dx + (dy = y - (double)center.y()) * dy + (dz = z - (double)center.z()) * dz <= this.radius * this.radius;
    }

    @Override
    public AreaType<?> getType() {
        return AreaType.SPHERE;
    }

    @Override
    public Optional<Integer> getMaximumPoints() {
        return Optional.of(1);
    }

    @Override
    public int getMinimumPoints() {
        return 1;
    }

    @Override
    protected void calculateEncompassingArea() {
        super.calculateEncompassingArea();
        Vector3ic center = this.getCenter();
        Vector3i min2 = new Vector3i((int)Math.floor((double)center.x() - this.radius), (int)Math.floor((double)center.y() - this.radius), (int)Math.floor((double)center.z() - this.radius));
        this.min.x = min2.x();
        this.min.y = min2.y();
        this.min.z = min2.z();
        Vector3i max = new Vector3i((int)Math.ceil((double)center.x() + this.radius), (int)Math.ceil((double)center.y() + this.radius), (int)Math.ceil((double)center.z() + this.radius));
        this.max.x = max.x();
        this.max.y = max.y();
        this.max.z = max.z();
    }

    public Vector3ic getCenter() {
        return (Vector3ic)this.points.stream().findFirst().orElse(new Vector3i());
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.calculateEncompassingArea();
    }

    @Override
    public Set<Vector3ic> generateBoundaryPoints() {
        Vector3ic c = this.getCenter();
        int samples = (int)(62.83185307179586 * this.radius);
        HashSet<Vector3ic> points = new HashSet<Vector3ic>(samples);
        for (int i = 0; i < samples; ++i) {
            double phi = Math.acos(2.0 * (double)i / (double)samples - 1.0);
            double theta = Math.PI * (1.0 + Math.sqrt(5.0)) * (double)i;
            double x = (double)c.x() + this.radius * Math.sin(phi) * Math.cos(theta);
            double y = (double)c.y() + this.radius * Math.sin(phi) * Math.sin(theta);
            double z = (double)c.z() + this.radius * Math.cos(phi);
            points.add((Vector3ic)new Vector3i((int)Math.round(x), (int)Math.round(y), (int)Math.round(z)));
        }
        return points;
    }
}

