/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.empirewar.orbis.Orbis;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.bukkit.task.BukkitRegionVisualiserTask;

public abstract class OrbisBukkitPlatform<P extends JavaPlugin>
extends OrbisPlatform
implements Orbis {
    protected static final NamespacedKey WAND_KEY = NamespacedKey.fromString((String)"orbis:wand");
    protected final P plugin;

    public OrbisBukkitPlatform(P plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void onEnable() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, (Runnable)new BukkitRegionVisualiserTask(this), 20L, 20L);
    }

    public boolean isWand(ItemStack stack) {
        return stack.getItemMeta() != null && stack.getItemMeta().getPersistentDataContainer().has(WAND_KEY);
    }

    public abstract ItemStack wandItem();

    public abstract Audience senderAsAudience(CommandSender var1);

    public abstract Key adventureKey(Keyed var1);

    @Override
    public boolean hasPermission(UUID player, String permission) {
        Player bukkit = Bukkit.getPlayer((UUID)player);
        if (bukkit == null) {
            return false;
        }
        return bukkit.hasPermission(permission);
    }

    @Override
    protected InputStream getResourceAsStream(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.plugin.getResource(path);
    }

    @Override
    public Path dataFolder() {
        return this.plugin.getDataFolder().toPath();
    }
}

