/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.listener;

import java.util.Collection;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;
import org.empirewar.orbis.bukkit.OrbisBukkitPlatform;
import org.empirewar.orbis.flag.DefaultFlags;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.query.RegionQuery;
import org.empirewar.orbis.world.RegionisedWorld;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public record BlockActionListener(OrbisBukkitPlatform<?> orbis) implements Listener
{
    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.shouldPreventBlockAction(block, event.getPlayer(), DefaultFlags.CAN_BREAK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (this.shouldPreventBlockAction(block, event.getPlayer(), DefaultFlags.CAN_PLACE)) {
            event.setCancelled(true);
            event.setBuild(false);
        }
    }

    @EventHandler
    public void onAttemptAccess(InventoryOpenEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockHolder = (BlockInventoryHolder)inventoryHolder;
            Block block = blockHolder.getBlock();
            event.setCancelled(this.shouldPreventBlockAction(block, DefaultFlags.BLOCK_INVENTORY_ACCESS));
        }
    }

    @EventHandler
    public void onRedstoneUse(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block != null && (block.getType() == Material.FARMLAND || block.getType() == Material.TURTLE_EGG)) {
            if (event.getAction() == Action.PHYSICAL && this.shouldPreventBlockAction(block, player, DefaultFlags.BLOCK_TRAMPLE)) {
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setCancelled(true);
            }
            return;
        }
        if (this.shouldPreventBlockAction(block, player, DefaultFlags.TRIGGER_REDSTONE)) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFade(BlockFadeEvent event) {
        Block block = event.getBlock();
        if (Tag.CORALS.isTagged((Keyed)block.getType())) {
            event.setCancelled(this.shouldPreventBlockAction(block, DefaultFlags.CORAL_DECAY));
        }
    }

    @EventHandler
    public void onDecay(LeavesDecayEvent event) {
        if (this.shouldPreventBlockAction(event.getBlock(), DefaultFlags.LEAF_DECAY)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onGrow(BlockGrowEvent event) {
        Block block = event.getBlock();
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)block.getWorld()));
        List growable = world.query(RegionQuery.Position.at(block.getX(), block.getY(), block.getZ())).query(RegionQuery.Flag.builder(DefaultFlags.GROWABLE_BLOCKS)).result().orElse(null);
        if (growable == null) {
            return;
        }
        if (!growable.contains(this.orbis.adventureKey((Keyed)block.getType()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSpread(BlockSpreadEvent event) {
        Block block = event.getBlock();
        if (Tag.FIRE.isTagged((Keyed)block.getType()) && this.shouldPreventBlockAction(block, DefaultFlags.FIRE_SPREAD)) {
            event.setCancelled(true);
            return;
        }
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)block.getWorld()));
        List growable = world.query(RegionQuery.Position.at(block.getX(), block.getY(), block.getZ())).query(RegionQuery.Flag.builder(DefaultFlags.GROWABLE_BLOCKS)).result().orElse(null);
        if (growable == null) {
            return;
        }
        if (!growable.contains(this.orbis.adventureKey((Keyed)block.getType()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPush(BlockPistonExtendEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    @EventHandler
    public void onPull(BlockPistonExtendEvent event) {
        this.handlePistonEvent((BlockPistonEvent)event, event.getBlocks());
    }

    private void handlePistonEvent(BlockPistonEvent event, Collection<Block> blocks) {
        for (Block block : blocks) {
            if (!this.shouldPreventBlockAction(block, DefaultFlags.ACTIVATE_PISTONS)) continue;
            event.setCancelled(true);
            return;
        }
    }

    private boolean shouldPreventBlockAction(@Nullable Block block, RegistryRegionFlag<Boolean> flag) {
        return this.shouldPreventBlockAction(block, null, flag);
    }

    private boolean shouldPreventBlockAction(@Nullable Block block, @Nullable Player player, RegistryRegionFlag<Boolean> flag) {
        boolean canAct;
        if (block == null) {
            return false;
        }
        Vector3d pos = new Vector3d((double)block.getX(), (double)block.getY(), (double)block.getZ());
        RegionisedWorld world = this.orbis.getRegionisedWorld(this.orbis.adventureKey((Keyed)block.getWorld()));
        RegionQuery.Flag.Builder<Boolean> builder = RegionQuery.Flag.builder(flag);
        if (player != null) {
            builder.player(player.getUniqueId());
        }
        return !(canAct = world.query(RegionQuery.Position.builder().position((Vector3dc)pos)).query(builder).result().orElse(true).booleanValue());
    }
}

