/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.bukkit.task;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.empirewar.orbis.OrbisPlatform;
import org.empirewar.orbis.task.RegionVisualiserTaskBase;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class BukkitRegionVisualiserTask
extends RegionVisualiserTaskBase {
    public BukkitRegionVisualiserTask(OrbisPlatform platform) {
        super(platform);
    }

    @Override
    protected Vector3dc getPlayerPosition(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        Location location = player.getLocation();
        return new Vector3d(location.getX(), location.getY(), location.getZ());
    }

    @Override
    protected void showGreenParticle(UUID uuid, Vector3dc point) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        Location loc = new Location(player.getWorld(), point.x(), point.y(), point.z());
        player.spawnParticle(Particle.HAPPY_VILLAGER, loc, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    protected void showOrangeParticle(UUID uuid, Vector3dc point) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        Location loc = new Location(player.getWorld(), point.x(), point.y(), point.z());
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)165, (int)0), 2.0f);
        player.spawnParticle(Particle.DUST, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
    }
}

