/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.caption.Caption;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.paper.libs.cloud.caption.StandardCaptionKeys;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.exception.ArgumentParseException;
import org.empirewar.orbis.paper.libs.cloud.exception.CommandExecutionException;
import org.empirewar.orbis.paper.libs.cloud.exception.InvalidCommandSenderException;
import org.empirewar.orbis.paper.libs.cloud.exception.InvalidSyntaxException;
import org.empirewar.orbis.paper.libs.cloud.exception.NoPermissionException;
import org.empirewar.orbis.paper.libs.cloud.exception.NoSuchCommandException;
import org.empirewar.orbis.paper.libs.cloud.exception.handling.ExceptionContext;
import org.empirewar.orbis.paper.libs.cloud.exception.handling.ExceptionController;
import org.empirewar.orbis.paper.libs.cloud.type.tuple.Pair;
import org.empirewar.orbis.paper.libs.cloud.type.tuple.Triplet;
import org.empirewar.orbis.paper.libs.cloud.util.TypeUtils;

@API(status=API.Status.INTERNAL)
final class DefaultExceptionHandlers<C> {
    private final Consumer<Triplet<CommandContext<C>, Caption, List<@NonNull CaptionVariable>>> messageSender;
    private final Consumer<Pair<String, Throwable>> logger;
    private final ExceptionController<C> exceptionController;

    DefaultExceptionHandlers(@NonNull Consumer<Triplet<CommandContext<C>, Caption, List<@NonNull CaptionVariable>>> messageSender, @NonNull Consumer<Pair<String, Throwable>> logger, @NonNull ExceptionController<C> exceptionController) {
        this.messageSender = Objects.requireNonNull(messageSender, "messageSender");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.exceptionController = Objects.requireNonNull(exceptionController, "exceptionController");
    }

    void register() {
        this.exceptionController.registerHandler(Throwable.class, context -> {
            this.sendMessage(context, StandardCaptionKeys.EXCEPTION_UNEXPECTED, new CaptionVariable[0]);
            this.log("An unhandled exception was thrown during command execution", (Throwable)context.exception());
        });
        this.exceptionController.registerHandler(CommandExecutionException.class, context -> {
            this.sendMessage(context, StandardCaptionKeys.EXCEPTION_UNEXPECTED, new CaptionVariable[0]);
            this.log("Exception executing command handler", ((CommandExecutionException)context.exception()).getCause());
        });
        this.exceptionController.registerHandler(ArgumentParseException.class, context -> this.sendMessage(context, StandardCaptionKeys.EXCEPTION_INVALID_ARGUMENT, CaptionVariable.of("cause", ((ArgumentParseException)context.exception()).getCause().getMessage())));
        this.exceptionController.registerHandler(NoSuchCommandException.class, context -> this.sendMessage(context, StandardCaptionKeys.EXCEPTION_NO_SUCH_COMMAND, CaptionVariable.of("command", ((NoSuchCommandException)context.exception()).suppliedCommand())));
        this.exceptionController.registerHandler(NoPermissionException.class, context -> this.sendMessage(context, StandardCaptionKeys.EXCEPTION_NO_PERMISSION, CaptionVariable.of("permission", ((NoPermissionException)context.exception()).permissionResult().permission().permissionString())));
        this.exceptionController.registerHandler(InvalidCommandSenderException.class, context -> {
            boolean multiple = ((InvalidCommandSenderException)context.exception()).requiredSenderTypes().size() != 1;
            String expected = multiple ? ((InvalidCommandSenderException)context.exception()).requiredSenderTypes().stream().map(TypeUtils::simpleName).collect(Collectors.joining(", ")) : TypeUtils.simpleName(((InvalidCommandSenderException)context.exception()).requiredSenderTypes().iterator().next());
            this.sendMessage(context, multiple ? StandardCaptionKeys.EXCEPTION_INVALID_SENDER_LIST : StandardCaptionKeys.EXCEPTION_INVALID_SENDER, CaptionVariable.of("actual", context.context().sender().getClass().getSimpleName()), CaptionVariable.of("expected", expected));
        });
        this.exceptionController.registerHandler(InvalidSyntaxException.class, context -> this.sendMessage(context, StandardCaptionKeys.EXCEPTION_INVALID_SYNTAX, CaptionVariable.of("syntax", ((InvalidSyntaxException)context.exception()).correctSyntax())));
    }

    private void sendMessage(@NonNull ExceptionContext<C, ?> context, @NonNull Caption caption, CaptionVariable ... variables) {
        this.sendMessage(context.context(), caption, variables);
    }

    private void sendMessage(@NonNull CommandContext<C> context, @NonNull Caption caption, CaptionVariable ... variables) {
        this.messageSender.accept(Triplet.of(context, caption, Arrays.asList(variables)));
    }

    private void log(@NonNull String message, @NonNull Throwable exception) {
        this.logger.accept(Pair.of(message, exception));
    }
}

