/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector;

import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;
import org.empirewar.orbis.paper.libs.cloud.bukkit.data.SinglePlayerSelector;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.PlayerParser;
import org.empirewar.orbis.paper.libs.cloud.bukkit.parser.selector.SelectorUtils;
import org.empirewar.orbis.paper.libs.cloud.component.CommandComponent;
import org.empirewar.orbis.paper.libs.cloud.context.CommandContext;
import org.empirewar.orbis.paper.libs.cloud.context.CommandInput;
import org.empirewar.orbis.paper.libs.cloud.parser.ArgumentParseResult;
import org.empirewar.orbis.paper.libs.cloud.parser.ParserDescriptor;

public final class SinglePlayerSelectorParser<C>
extends SelectorUtils.PlayerSelectorParser<C, SinglePlayerSelector> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, SinglePlayerSelector> singlePlayerSelectorParser() {
        return ParserDescriptor.of(new SinglePlayerSelectorParser<C>(), SinglePlayerSelector.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, SinglePlayerSelector> singlePlayerSelectorComponent() {
        return CommandComponent.builder().parser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
    }

    public SinglePlayerSelectorParser() {
        super(true);
    }

    @Override
    @API(status=API.Status.INTERNAL, consumers={"org.empirewar.orbis.paper.libs.cloud.*"})
    public SinglePlayerSelector mapResult(final @NonNull String input, @NonNull SelectorUtils.EntitySelectorWrapper wrapper) {
        final Player player = wrapper.singlePlayer();
        return new SinglePlayerSelector(){

            @Override
            public @NonNull Player single() {
                return player;
            }

            @Override
            public @NonNull String inputString() {
                return input;
            }
        };
    }

    @Override
    protected @NonNull CompletableFuture<ArgumentParseResult<SinglePlayerSelector>> legacyParse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        final @Nullable Player player = Bukkit.getPlayer((String)input);
        if (player == null) {
            return CompletableFuture.completedFuture(ArgumentParseResult.failure(new PlayerParser.PlayerParseException(input, commandContext)));
        }
        final String pop = commandInput.readString();
        return ArgumentParseResult.successFuture(new SinglePlayerSelector(){

            @Override
            public @NonNull Player single() {
                return player;
            }

            @Override
            public @NonNull String inputString() {
                return pop;
            }
        });
    }
}

