/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.caption;

import java.util.LinkedList;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.common.returnsreceiver.qual.This;
import org.empirewar.orbis.paper.libs.cloud.caption.Caption;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionProvider;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionRegistry;

@API(status=API.Status.INTERNAL)
public final class CaptionRegistryImpl<C>
implements CaptionRegistry<C> {
    private final LinkedList<@NonNull CaptionProvider<C>> providers = new LinkedList();

    CaptionRegistryImpl() {
    }

    @Override
    public @NonNull String caption(@NonNull Caption caption, @NonNull C sender) {
        for (CaptionProvider captionProvider : this.providers) {
            String result = captionProvider.provide(caption, sender);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException(String.format("There is no caption stored with key '%s'", caption));
    }

    @Override
    public @This @NonNull CaptionRegistry<C> registerProvider(@NonNull CaptionProvider<C> provider) {
        this.providers.addFirst(provider);
        return this;
    }
}

