/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.minecraft.extras.caption;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.caption.Caption;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionFormatter;
import org.empirewar.orbis.paper.libs.cloud.caption.CaptionVariable;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.caption.MiniMessageComponentCaptionFormatter;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.caption.PatternReplacingComponentCaptionFormatter;
import org.empirewar.orbis.paper.libs.cloud.minecraft.extras.caption.RichVariable;

@API(status=API.Status.STABLE, since="2.0.0")
public interface ComponentCaptionFormatter<C>
extends CaptionFormatter<C, Component> {
    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage() {
        return ComponentCaptionFormatter.miniMessage(MiniMessage.miniMessage());
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage(@NonNull MiniMessage miniMessage) {
        return ComponentCaptionFormatter.miniMessage(miniMessage, new TagResolver[0]);
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> miniMessage(@NonNull MiniMessage miniMessage, TagResolver ... resolvers) {
        return new MiniMessageComponentCaptionFormatter(miniMessage, Arrays.asList(resolvers));
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static <C> @NonNull ComponentCaptionFormatter<C> translatable() {
        return new ComponentCaptionFormatter<C>(){

            @Override
            public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
                return Component.translatable((String)captionKey.key(), variables.stream().map(variable -> {
                    if (variable instanceof RichVariable) {
                        return (RichVariable)variable;
                    }
                    return Component.text((String)variable.value());
                }).collect(Collectors.toList()));
            }
        };
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> patternReplacing(@NonNull Pattern pattern) {
        return new PatternReplacingComponentCaptionFormatter(pattern);
    }

    public static <C> @NonNull ComponentCaptionFormatter<C> placeholderReplacing() {
        return new PatternReplacingComponentCaptionFormatter(CaptionFormatter.placeholderPattern());
    }
}

