/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.permission;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.cloud.key.CloudKey;
import org.empirewar.orbis.paper.libs.cloud.permission.PermissionResult;
import org.empirewar.orbis.paper.libs.cloud.permission.PredicatePermission;

@API(status=API.Status.INTERNAL, consumers={"org.empirewar.orbis.paper.libs.cloud.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    @Override
    public @NonNull PermissionResult testPermission(@NonNull C sender) {
        return PermissionResult.of(this.predicate.test(sender), this);
    }

    @Override
    public @NonNull CloudKey<Void> key() {
        return this.key;
    }

    public String toString() {
        return this.key.name();
    }
}

