/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.cloud.processors.cache;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.NonNull;
import org.empirewar.orbis.paper.libs.checker.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.0.0")
public interface CloudCache<K, V> {
    public void delete(@NonNull K var1);

    public void put(@NonNull K var1, @NonNull V var2);

    public @Nullable V getIfPresent(@NonNull K var1);

    default public @Nullable V popIfPresent(@NonNull K key) {
        V value = this.getIfPresent(key);
        if (value != null) {
            this.delete(key);
        }
        return value;
    }

    default public @NonNull Optional<V> get(@NonNull K key) {
        return Optional.ofNullable(this.getIfPresent(key));
    }

    default public <K1> @NonNull CloudCache<K1, V> keyExtractingView(final @NonNull Function<K1, K> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor");
        return new CloudCache<K1, V>(){

            @Override
            public void delete(@NonNull K1 key) {
                CloudCache.this.delete(keyExtractor.apply(key));
            }

            @Override
            public void put(@NonNull K1 key, @NonNull V value) {
                CloudCache.this.put(keyExtractor.apply(key), value);
            }

            @Override
            public @Nullable V getIfPresent(@NonNull K1 key) {
                return CloudCache.this.getIfPresent(keyExtractor.apply(key));
            }

            @Override
            public @Nullable V popIfPresent(@NonNull K1 key) {
                return CloudCache.this.popIfPresent(keyExtractor.apply(key));
            }

            @Override
            public @NonNull Optional<V> get(@NonNull K1 key) {
                return CloudCache.this.get(keyExtractor.apply(key));
            }
        };
    }
}

