/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.rtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> filter(Iterable<? extends T> iterable, Predicate<? super T> condition) {
        return new FilterIterable<T>(iterable, condition);
    }

    public static long size(Iterable<?> iterable) {
        Iterator<?> it = iterable.iterator();
        long count = 0L;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static boolean isEmpty(Iterable<?> entries) {
        return !entries.iterator().hasNext();
    }

    static final class FilterIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> it;
        private final Predicate<? super T> condition;
        private T next;

        FilterIterator(Iterator<? extends T> it, Predicate<? super T> condition) {
            this.it = it;
            this.condition = condition;
        }

        @Override
        public boolean hasNext() {
            this.load();
            return this.next != null;
        }

        @Override
        public T next() {
            this.load();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T v = this.next;
            this.next = null;
            return v;
        }

        private void load() {
            if (this.next == null && this.it != null) {
                while (this.it.hasNext()) {
                    T v = this.it.next();
                    if (!this.condition.test(v)) continue;
                    this.next = v;
                    return;
                }
                this.it = null;
            }
        }
    }

    static final class FilterIterable<T>
    implements Iterable<T> {
        private final Iterable<? extends T> iterable;
        private final Predicate<? super T> condition;

        FilterIterable(Iterable<? extends T> iterable, Predicate<? super T> condition) {
            this.iterable = iterable;
            this.condition = condition;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilterIterator<T>(this.iterable.iterator(), this.condition);
        }
    }
}

