/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.paper.libs.rtree.geometry;

import java.util.List;
import org.empirewar.orbis.paper.libs.rtree.geometry.Group;
import org.empirewar.orbis.paper.libs.rtree.geometry.HasGeometry;

public final class ListPair<T extends HasGeometry> {
    private final Group<T> group1;
    private final Group<T> group2;
    private double volumeSum = -1.0;
    private final double marginSum;

    public ListPair(List<T> list1, List<T> list2) {
        this.group1 = new Group<T>(list1);
        this.group2 = new Group<T>(list2);
        this.marginSum = this.group1.geometry().mbr().surfaceArea() + this.group2.geometry().mbr().surfaceArea();
    }

    public Group<T> group1() {
        return this.group1;
    }

    public Group<T> group2() {
        return this.group2;
    }

    public double volumeSum() {
        if (this.volumeSum == -1.0) {
            this.volumeSum = this.group1.geometry().mbr().volume() + this.group2.geometry().mbr().volume();
        }
        return this.volumeSum;
    }

    public double marginSum() {
        return this.marginSum;
    }
}

