/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.OrbisAPI;
import org.empirewar.orbis.registry.OrbisRegistry;
import org.empirewar.orbis.registry.lifecycle.RegistryLifecycle;
import org.empirewar.orbis.registry.lifecycle.RegistryLifecycles;

public abstract class SimpleOrbisRegistry<T, K>
implements OrbisRegistry<T, K> {
    protected final Key registryKey;
    protected final Map<K, T> entries = new HashMap<K, T>();
    protected RegistryLifecycle lifecycle = RegistryLifecycles.loading();

    public SimpleOrbisRegistry(Key registryKey) {
        this.registryKey = registryKey;
    }

    public Key key() {
        return this.registryKey;
    }

    @Override
    public T register(K key, T entry) {
        if (this.lifecycle == RegistryLifecycles.frozen()) {
            throw new IllegalStateException("Registry is frozen");
        }
        if (this.entries.containsKey(key)) {
            throw new IllegalArgumentException("Entry already exists");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null");
        }
        this.entries.put(key, entry);
        return entry;
    }

    @Override
    public Optional<T> unregister(K key) {
        if (this.lifecycle == RegistryLifecycles.frozen()) {
            throw new IllegalStateException("Registry is frozen");
        }
        T entry = this.entries.remove(key);
        return Optional.ofNullable(entry);
    }

    @Override
    public Optional<T> get(K key) {
        return Optional.ofNullable(this.entries.get(key));
    }

    @Override
    public Optional<K> getKey(T entry) {
        for (Map.Entry<K, T> e : this.entries.entrySet()) {
            if (!Objects.equals(e.getValue(), entry)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    @Override
    public Set<T> getAll() {
        return new HashSet<T>(this.entries.values());
    }

    @Override
    public Set<K> getKeys() {
        return new HashSet<K>(this.entries.keySet());
    }

    @Override
    public RegistryLifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public void setLifecycle(RegistryLifecycle lifecycle) {
        if (lifecycle.equals(this.lifecycle)) {
            throw new IllegalArgumentException("Lifecycle has not changed");
        }
        if (OrbisAPI.get() != null) {
            OrbisAPI.get().logger().info("Registry '{}' lifecycle changed from {} to {}", new Object[]{this.key().asString(), this.lifecycle.name(), lifecycle.name()});
        }
        this.lifecycle = lifecycle;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.registryKey) + "]";
    }

    @Override
    public Iterator<T> iterator() {
        return this.entries.values().iterator();
    }
}

