/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.flag;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import org.empirewar.orbis.flag.RegistryRegionFlag;
import org.empirewar.orbis.registry.OrbisRegistries;
import org.empirewar.orbis.util.ExtraCodecs;

public final class DefaultFlags {
    public static final RegistryRegionFlag<Boolean> CAN_BREAK = DefaultFlags.register("can_break", "Whether players can break blocks", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_PLACE = DefaultFlags.register("can_place", "Whether players can place blocks", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_PVP = DefaultFlags.register("can_pvp", "Whether players can attack each other", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_TAKE_MOB_DAMAGE_SOURCES = DefaultFlags.register("can_take_mob_damage_sources", "Whether players can take damage from mobs", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<List<Key>> DAMAGEABLE_ENTITIES = DefaultFlags.register("damageable_entities", "An array of entity keys that can be attacked", ArrayList::new, ExtraCodecs.KEY.listOf());
    public static final RegistryRegionFlag<Boolean> CAN_DESTROY_ITEM_FRAME = DefaultFlags.register("can_destroy_item_frame", "Whether item frames can be destroyed", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_DESTROY_PAINTING = DefaultFlags.register("can_destroy_painting", "Whether paintings can be destroyed", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_DESTROY_VEHICLE = DefaultFlags.register("can_destroy_vehicle", "Whether vehicles can be destroyed", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> FALL_DAMAGE = DefaultFlags.register("fall_damage", "Whether players take fall damage", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_DROP_ITEM = DefaultFlags.register("can_drop_item", "Whether players can drop items", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_PICKUP_ITEM = DefaultFlags.register("can_pickup_item", "Whether players can pick up items", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> BLOCK_INVENTORY_ACCESS = DefaultFlags.register("block_inventory_access", "Whether players can access block inventories (such as barrels)", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> TRIGGER_REDSTONE = DefaultFlags.register("trigger_redstone", "Whether players can trigger redstone", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> ACTIVATE_PISTONS = DefaultFlags.register("activate_pistons", "Whether pistons can push and pull when activated (also prevents blocks being pushed from/into outside the region)", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CORAL_DECAY = DefaultFlags.register("coral_decay", "Whether coral should bleach naturally", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> LEAF_DECAY = DefaultFlags.register("leaf_decay", "Whether leaves should decay naturally", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<List<Key>> GROWABLE_BLOCKS = DefaultFlags.register("growable_blocks", "An array of block keys that can grow with age (e.g. wheat, sugarcane, but not grass)", ArrayList::new, ExtraCodecs.KEY.listOf());
    public static final RegistryRegionFlag<Boolean> BLOCK_TRAMPLE = DefaultFlags.register("block_trample", "Whether blocks such as farmland can be trampled (turned to dirt)", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> ITEM_FRAME_ROTATE = DefaultFlags.register("item_frame_rotate", "Whether item frames can be rotated", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> ITEM_FRAME_ITEM_PLACE = DefaultFlags.register("item_frame_item_place", "Whether items can be placed into item frames", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> CAN_ENTER = DefaultFlags.register("can_enter", "Whether players can enter this region. Useful when combined with flag groups.", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> DRAIN_HUNGER = DefaultFlags.register("drain_hunger", "Whether players should lose hunger (cancels plugin sources)", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Boolean> FIRE_SPREAD = DefaultFlags.register("fire_spread", "Whether fire should spread naturally", () -> true, Codec.BOOL);
    public static final RegistryRegionFlag<Long> TIME = DefaultFlags.register("time", "An integer/long specifying the time of day in ticks", () -> 12000L, Codec.LONG);
    public static final RegistryRegionFlag<Boolean> INVULNERABILITY = DefaultFlags.register("invulnerability", "Whether players should take damage from any source", () -> false, Codec.BOOL);
    public static final RegistryRegionFlag<String> ENTRY_MESSAGE = DefaultFlags.register("entry_message", "A message to display when a player enters this region (supports MiniMessage)", () -> "", Codec.STRING);
    public static final RegistryRegionFlag<String> EXIT_MESSAGE = DefaultFlags.register("exit_message", "A message to display when a player leaves this region (supports MiniMessage)", () -> "", Codec.STRING);

    private static <T> RegistryRegionFlag<T> register(String name, Supplier<T> defaultValue, Codec<T> codec) {
        return DefaultFlags.register(name, null, defaultValue, codec);
    }

    private static <T> RegistryRegionFlag<T> register(String name, String description, Supplier<T> defaultValue, Codec<T> codec) {
        Key key = Key.key((String)"orbis", (String)name);
        RegistryRegionFlag.Builder entry = RegistryRegionFlag.builder().key(key).codec(codec).defaultValue(defaultValue);
        if (description != null) {
            entry.description(description);
        }
        RegistryRegionFlag built = entry.build();
        OrbisRegistries.FLAGS.register(key, built);
        return built;
    }
}

