/*
 * Decompiled with CFR 0.152.
 */
package org.empirewar.orbis.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.empirewar.orbis.area.AreaType;
import org.empirewar.orbis.area.PolygonArea;
import org.empirewar.orbis.util.ExtraCodecs;
import org.empirewar.orbis.util.QuickHull3D;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class PolyhedralArea
extends PolygonArea {
    public static final MapCodec<PolyhedralArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VEC_3I.listOf().fieldOf("points").forGetter(c -> new LinkedList(c.points))).apply((Applicative)instance, PolyhedralArea::new));
    private static final double EPSILON = 1.0E-7;
    private List<Edge> edges;
    private List<Face> faces;

    public PolyhedralArea() {
    }

    private PolyhedralArea(List<Vector3ic> points) {
        super(points);
    }

    @Override
    protected void calculateEncompassingArea() {
        super.calculateEncompassingArea();
        try {
            this.faces = this.getPolyhedronFaces();
            this.edges = this.getPolyhedronEdges(this.faces);
            this.boundaryPoints.clear();
            if (this.points.size() >= this.getMinimumPoints()) {
                this.boundaryPoints.addAll(this.generateBoundaryPoints());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public boolean contains(double x, double y, double z) {
        if (x < (double)this.min.x() - 1.0E-7 || x > (double)this.max.x() + 1.0E-7 || y < (double)this.min.y() - 1.0E-7 || y > (double)this.max.y() + 1.0E-7 || z < (double)this.min.z() - 1.0E-7 || z > (double)this.max.z() + 1.0E-7) {
            return false;
        }
        Vector3d point = new Vector3d(x, y, z);
        for (Vector3ic vertex : this.points) {
            double dist = point.distanceSquared((double)vertex.x(), (double)vertex.y(), (double)vertex.z());
            if (!(dist < 9.999999999999998E-15)) continue;
            return true;
        }
        for (Edge edge : this.edges) {
            Vector3d v1 = new Vector3d((double)edge.v1().x, (double)edge.v1().y, (double)edge.v1().z);
            Vector3d v2 = new Vector3d((double)edge.v2().x, (double)edge.v2().y, (double)edge.v2().z);
            if (!this.isPointOnEdge((Vector3dc)point, (Vector3dc)v1, (Vector3dc)v2)) continue;
            return true;
        }
        Vector3d rayDir = new Vector3d(1.0, 0.5, 0.3).normalize();
        int intersections = 0;
        for (Face face : this.faces) {
            List<Vertex> verts = face.vertices();
            Vector3d[] vertices = (Vector3d[])verts.stream().map(v -> new Vector3d((double)v.x, (double)v.y, (double)v.z)).toArray(Vector3d[]::new);
            if (this.isPointOnFace((Vector3dc)point, (Vector3dc[])vertices)) {
                return true;
            }
            int faceIntersections = 0;
            for (int i = 1; i < vertices.length - 1; ++i) {
                if (!this.rayIntersectsTriangle((Vector3dc)point, (Vector3dc)rayDir, (Vector3dc)vertices[0], (Vector3dc)vertices[i], (Vector3dc)vertices[i + 1])) continue;
                ++faceIntersections;
            }
            intersections += faceIntersections;
        }
        return intersections % 2 == 1;
    }

    private List<Face> getPolyhedronFaces() {
        if (this.points.size() < 4) {
            return List.of();
        }
        double[] coords = new double[this.points.size() * 3];
        int i = 0;
        for (Vector3ic point : this.points) {
            coords[i++] = point.x();
            coords[i++] = point.y();
            coords[i++] = point.z();
        }
        QuickHull3D hull = new QuickHull3D();
        hull.build(coords);
        int[][] faceIndices = hull.getFaces();
        LinkedList pointsList = new LinkedList(this.points);
        ArrayList<Face> faces = new ArrayList<Face>();
        for (int[] face : faceIndices) {
            ArrayList<Vertex> verts = new ArrayList<Vertex>();
            for (int v : face) {
                Vector3ic p = (Vector3ic)pointsList.get(v);
                verts.add(new Vertex(p));
            }
            faces.add(new Face(verts));
        }
        return faces;
    }

    private List<Edge> getPolyhedronEdges(List<Face> faces) {
        HashSet<CallSite> edgeSet = new HashSet<CallSite>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Face face : faces) {
            List<Vertex> verts = face.vertices();
            for (int i = 0; i < verts.size(); ++i) {
                String key;
                Vertex v1 = verts.get(i);
                Vertex v2 = verts.get((i + 1) % verts.size());
                String string = key = v1.toString().compareTo(v2.toString()) < 0 ? String.valueOf(v1) + "-" + String.valueOf(v2) : String.valueOf(v2) + "-" + String.valueOf(v1);
                if (!edgeSet.add((CallSite)((Object)key))) continue;
                edges.add(new Edge(v1, v2));
            }
        }
        return edges;
    }

    private boolean rayIntersectsTriangle(Vector3dc rayOrigin, Vector3dc rayDir, Vector3dc v0, Vector3dc v1, Vector3dc v2) {
        Vector3d edge1 = new Vector3d();
        Vector3d edge2 = new Vector3d();
        v1.sub(v0, edge1);
        v2.sub(v0, edge2);
        Vector3d pvec = new Vector3d();
        rayDir.cross((Vector3dc)edge2, pvec);
        double det = edge1.dot((Vector3dc)pvec);
        if (Math.abs(det) < 1.0E-7) {
            return false;
        }
        double invDet = 1.0 / det;
        Vector3d tvec = new Vector3d(rayOrigin).sub(v0);
        double u = tvec.dot((Vector3dc)pvec) * invDet;
        if (u < -1.0E-7 || u > 1.0000001) {
            return false;
        }
        Vector3d qvec = new Vector3d();
        tvec.cross((Vector3dc)edge1, qvec);
        double v = rayDir.dot((Vector3dc)qvec) * invDet;
        if (v < -1.0E-7 || u + v > 1.0000001) {
            return false;
        }
        double t = edge2.dot((Vector3dc)qvec) * invDet;
        return t >= -1.0E-7;
    }

    private boolean isPointOnFace(Vector3dc point, Vector3dc[] faceVertices) {
        int coord2;
        int coord1;
        if (faceVertices.length < 3) {
            return false;
        }
        Vector3d v1 = new Vector3d(faceVertices[1]).sub(faceVertices[0]);
        Vector3d v2 = new Vector3d(faceVertices[2]).sub(faceVertices[0]);
        Vector3d normal = new Vector3d();
        v1.cross((Vector3dc)v2, normal);
        Vector3d p0 = new Vector3d(faceVertices[0]);
        Vector3d p = new Vector3d(point);
        p.sub((Vector3dc)p0);
        double dist = Math.abs(p.dot((Vector3dc)normal));
        if (dist > 1.0E-7) {
            return false;
        }
        double max = Math.max(Math.abs(normal.x), Math.max(Math.abs(normal.y), Math.abs(normal.z)));
        if (Math.abs(normal.x) == max) {
            coord1 = 1;
            coord2 = 2;
        } else if (Math.abs(normal.y) == max) {
            coord1 = 0;
            coord2 = 2;
        } else {
            coord1 = 0;
            coord2 = 1;
        }
        int n = faceVertices.length;
        boolean inside = false;
        int i = 0;
        int j = n - 1;
        while (i < n) {
            double py;
            double[] vj = new double[]{faceVertices[j].x(), faceVertices[j].y(), faceVertices[j].z()};
            double[] vi = new double[]{faceVertices[i].x(), faceVertices[i].y(), faceVertices[i].z()};
            double x1 = vj[coord1];
            double y1 = vj[coord2];
            double x2 = vi[coord1];
            double y2 = vi[coord2];
            double px = point.get(coord1);
            if (this.isPointOnEdge(px, py = point.get(coord2), x1, y1, x2, y2)) {
                return true;
            }
            if (y1 > py != y2 > py && px < (x2 - x1) * (py - y1) / (y2 - y1) + x1) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    private boolean isPointOnEdge(double px, double py, double x1, double y1, double x2, double y2) {
        if (px < Math.min(x1, x2) - 1.0E-7 || px > Math.max(x1, x2) + 1.0E-7 || py < Math.min(y1, y2) - 1.0E-7 || py > Math.max(y1, y2) + 1.0E-7) {
            return false;
        }
        double cross = (y2 - y1) * (px - x1) - (x2 - x1) * (py - y1);
        return Math.abs(cross) < 1.0E-7;
    }

    private boolean isPointOnEdge(Vector3dc point, Vector3dc v1, Vector3dc v2) {
        Vector3d v1ToPoint = new Vector3d(point).sub(v1);
        Vector3d edge = new Vector3d(v2).sub(v1);
        Vector3d cross = new Vector3d();
        v1ToPoint.cross((Vector3dc)edge, cross);
        if (cross.lengthSquared() > 9.999999999999998E-15) {
            return false;
        }
        double t = v1ToPoint.dot((Vector3dc)edge) / edge.lengthSquared();
        return t >= -1.0E-7 && t <= 1.0000001;
    }

    @Override
    public Set<Vector3ic> getBoundaryPoints() {
        HashSet<Vector3ic> points = new HashSet<Vector3ic>();
        if (this.edges == null) {
            this.calculateEncompassingArea();
        }
        if (this.edges != null) {
            for (Edge edge : this.edges) {
                Vector3i a = edge.v1().toVector3i();
                Vector3i b = edge.v2().toVector3i();
                points.addAll(this.getLinePoints((Vector3ic)a, (Vector3ic)b));
            }
        }
        return points;
    }

    private Set<Vector3i> getLinePoints(Vector3ic start, Vector3ic end) {
        HashSet<Vector3i> points = new HashSet<Vector3i>();
        int x1 = start.x();
        int y1 = start.y();
        int z1 = start.z();
        int x2 = end.x();
        int y2 = end.y();
        int z2 = end.z();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int n = Math.max(Math.max(dx, dy), dz);
        for (int i = 0; i <= n; ++i) {
            int x = x1 + i * (x2 - x1) / n;
            int y = y1 + i * (y2 - y1) / n;
            int z = z1 + i * (z2 - z1) / n;
            points.add(new Vector3i(x, y, z));
        }
        return points;
    }

    @Override
    public int getMinimumPoints() {
        return 4;
    }

    @Override
    public AreaType<?> getType() {
        return AreaType.POLYHEDRAL;
    }

    public record Edge(Vertex v1, Vertex v2) {
    }

    public record Vertex(int x, int y, int z) {
        public Vertex(Vector3ic v) {
            this(v.x(), v.y(), v.z());
        }

        public Vector3i toVector3i() {
            return new Vector3i(this.x, this.y, this.z);
        }
    }

    public record Face(List<Vertex> vertices) {
    }
}

