/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.forge;

import com.mojang.blaze3d.platform.InputConstants;
import kotlin.Unit;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.anti_ad.mc.common.gui.NativeContext;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.ipnext.config.Tweaks;
import org.anti_ad.mc.ipnext.event.ClientEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ContainerScreenEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ScreenEventHandler;
import org.anti_ad.mc.ipnext.inventory.GeneralInventoryActions;

public class ForgeEventHandler {
    @SubscribeEvent
    public void clientClick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            ClientEventHandler.INSTANCE.onTickPre();
            return;
        }
        ClientEventHandler.INSTANCE.onTick();
    }

    @SubscribeEvent
    public void onPlayerLogInEvent(ClientPlayerNetworkEvent.LoggingIn loggingIn) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinGame();
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void joinWorld(LevelEvent.Load load) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinGame();
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent itemCraftedEvent) {
        ClientEventHandler.INSTANCE.onCrafted();
    }

    @SubscribeEvent
    public void onInitGuiPost(ScreenEvent.Init.Post post) {
        ScreenEventHandler.INSTANCE.onScreenInit(post.getScreen(), abstractButton -> {
            post.addListener((GuiEventListener)abstractButton);
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void preScreenRender(ScreenEvent.Render.Pre pre) {
        ScreenEventHandler.INSTANCE.preRender(new NativeContext(pre.getGuiGraphics(), RenderType::guiTextured));
    }

    @SubscribeEvent
    public void postScreenRender(ScreenEvent.Render.Post post) {
        ScreenEventHandler.INSTANCE.postRender(new NativeContext(post.getGuiGraphics(), RenderType::guiTextured));
    }

    @SubscribeEvent
    public void onBackgroundRender(ContainerScreenEvent.Render.Background background) {
        NativeContext nativeContext = new NativeContext(background.getGuiGraphics(), RenderType::guiTextured);
        ContainerScreenEventHandler.INSTANCE.onBackgroundRender(nativeContext, background.getMouseX(), background.getMouseY(), 0.0f);
    }

    @SubscribeEvent
    public void onForegroundRender(ContainerScreenEvent.Render.Foreground foreground) {
        NativeContext nativeContext = new NativeContext(foreground.getGuiGraphics(), RenderType::guiTextured);
        nativeContext.setOverlay(true);
        nativeContext.setOverlay(true);
        AbstractContainerScreen abstractContainerScreen = foreground.getContainerScreen();
        nativeContext.getNative().pose().pushPose();
        abstractContainerScreen = new Rectangle(abstractContainerScreen.getGuiLeft(), abstractContainerScreen.getGuiTop(), abstractContainerScreen.getXSize(), abstractContainerScreen.getYSize()).getTopLeft();
        nativeContext.getNative().pose().translate((double)(-abstractContainerScreen.getX()), (double)(-abstractContainerScreen.getY()), 0.0);
        ContainerScreenEventHandler.INSTANCE.onForegroundRender(nativeContext, foreground.getMouseX(), foreground.getMouseY(), 0.0f);
        nativeContext.getNative().pose().popPose();
    }

    @SubscribeEvent
    public void onGuiKeyPressedPre(ScreenEvent.KeyPressed.Pre pre) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        InputConstants.Key key = InputConstants.getKey((int)pre.getKeyCode(), (int)pre.getScanCode());
        if (Tweaks.INSTANCE.getPREVENT_CLOSE_GUI_DROP_ITEM().getBooleanValue() && (pre.getKeyCode() == 256 || Vanilla.INSTANCE.mc().options.keyInventory.isActiveAndMatches(key))) {
            GeneralInventoryActions.INSTANCE.handleCloseContainer();
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenEvent.Closing closing) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        ScreenEventHandler.INSTANCE.onScreenRemoved(closing.getScreen());
    }
}

