/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import org.anti_ad.mc.ipnext.item.ImmutableItemStack;
import org.anti_ad.mc.ipnext.item.ItemStack$Companion;
import org.anti_ad.mc.ipnext.item.ItemStackExtensionsKt;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.anti_ad.mc.ipnext.item.MutableItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nItemStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemStack.kt\norg/anti_ad/mc/ipnext/item/ItemStack\n+ 2 ItemTypeExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemTypeExtensionsKt\n*L\n1#1,94:1\n102#2,9:95\n102#2,9:104\n*S KotlinDebug\n*F\n+ 1 ItemStack.kt\norg/anti_ad/mc/ipnext/item/ItemStack\n*L\n34#1:95,9\n37#1:104,9\n*E\n"})
public abstract sealed class ItemStack
permits ImmutableItemStack, MutableItemStack {
    @NotNull
    public static final ItemStack$Companion Companion = new ItemStack$Companion(null);

    private ItemStack() {
    }

    @NotNull
    public abstract ItemType getItemType();

    public abstract int getCount();

    @Nullable
    public abstract Slot getSourceSlot();

    public abstract void setSourceSlot(@Nullable Slot var1);

    @NotNull
    public final ItemType component1() {
        return this.getItemType();
    }

    public final int component2() {
        return this.getCount();
    }

    public final boolean getOverstacked() {
        int n2 = this.getCount();
        ItemType itemType = this.getItemType();
        ItemLike itemLike = (ItemLike)itemType.getItem();
        PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        return n2 > new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize();
    }

    public final boolean getOverstackedAndNotManageable() {
        int n2 = this.getCount();
        ItemType itemType = this.getItemType();
        ItemLike itemLike = (ItemLike)itemType.getItem();
        PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        return n2 > new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize() && this.getCount() > 64;
    }

    @NotNull
    public final String toString() {
        return this.getCount() + "x " + this.getItemType();
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ItemStack)) {
            return false;
        }
        if (ItemStackExtensionsKt.isEmpty(this) && ItemStackExtensionsKt.isEmpty((ItemStack)object)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.getItemType(), (Object)((ItemStack)object).getItemType())) {
            return false;
        }
        return this.getCount() == ((ItemStack)object).getCount();
    }

    public final int hashCode() {
        if (ItemStackExtensionsKt.isEmpty(this)) {
            return 0;
        }
        return this.getItemType().hashCode() * 31 + this.getCount();
    }

    @NotNull
    public final MutableItemStack copyAsMutable() {
        return new MutableItemStack(this.getItemType(), this.getCount(), this.getSourceSlot());
    }

    public /* synthetic */ ItemStack(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }
}

