/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.anti_ad.mc.ipnext.item.ItemStack$Companion;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.anti_ad.mc.ipnext.item.ItemTypeExtensionsKt;
import org.anti_ad.mc.ipnext.item.ItemTypeExtensionsKt$EMPTY$1;
import org.anti_ad.mc.ipnext.item.MutableItemStack;
import org.anti_ad.mc.ipnext.item.MutableItemStack$Companion;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nItemStackExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemStackExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemStackExtensionsKt\n+ 2 ItemTypeExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemTypeExtensionsKt\n+ 3 kt_common.kt\norg/anti_ad/mc/common/extensions/Kt_commonKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ItemStack.kt\norg/anti_ad/mc/ipnext/item/ItemStack\n*L\n1#1,118:1\n91#2,4:119\n91#2,4:125\n101#2,9:129\n101#2,9:140\n101#2,9:149\n101#2,9:158\n91#2,4:167\n91#2,4:171\n101#2,9:177\n101#2,9:187\n130#3:123\n130#3:138\n1#4:124\n1#4:139\n1#4:175\n34#5:176\n34#5:186\n*S KotlinDebug\n*F\n+ 1 ItemStackExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemStackExtensionsKt\n*L\n34#1:119,4\n39#1:125,4\n44#1:129,9\n45#1:140,9\n54#1:149,9\n58#1:158,9\n67#1:167,4\n71#1:171,4\n93#1:177,9\n101#1:187,9\n38#1:123\n44#1:138\n38#1:124\n44#1:139\n93#1:176\n101#1:186\n*E\n"})
public final class ItemStackExtensionsKt {
    @NotNull
    public static final ItemStack getEMPTY(@NotNull ItemStack$Companion itemStack$Companion) {
        Intrinsics.checkNotNullParameter((Object)itemStack$Companion, (String)"");
        Item item = Items.AIR;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
        return ItemStack.Companion.invoke(new ItemType(item, new PatchedDataComponentMap(Items.AIR.components()), DataComponentPatch.EMPTY, ItemTypeExtensionsKt$EMPTY$1.INSTANCE, false, false, null, 112, null), 0);
    }

    public static final boolean isEmpty(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        boolean bl = ItemTypeExtensionsKt.isEmpty(itemStack.getItemType()) || itemStack.getCount() <= 0;
        boolean bl2 = bl;
        if (bl) {
            ItemType itemType = itemStack.getItemType();
            Item item = Items.AIR;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
            if (!Intrinsics.areEqual((Object)itemType, (Object)new ItemType(item, new PatchedDataComponentMap(Items.AIR.components()), DataComponentPatch.EMPTY, ItemTypeExtensionsKt$EMPTY$1.INSTANCE, false, false, null, 112, null)) || itemStack.getCount() != 0) {
                Log.INSTANCE.warn("Informal item stack " + itemStack);
            }
        }
        return bl2;
    }

    public static final boolean isFull(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        int n2 = itemStack.getCount();
        ItemType itemType = itemStack.getItemType();
        ItemLike itemLike = (ItemLike)itemType.getItem();
        PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        boolean bl = n2 >= new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize();
        boolean bl2 = bl;
        if (bl) {
            int n3 = itemStack.getCount();
            ItemType itemType2 = itemStack.getItemType();
            ItemLike itemLike2 = (ItemLike)itemType2.getItem();
            PatchedDataComponentMap patchedDataComponentMap2 = itemType2.getTag();
            if (patchedDataComponentMap2 == null) {
                DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
                Intrinsics.checkNotNull((Object)dataComponentMap);
                patchedDataComponentMap2 = (PatchedDataComponentMap)dataComponentMap;
            }
            if (n3 != new net.minecraft.world.item.ItemStack(itemLike2, 1, patchedDataComponentMap2).getMaxStackSize()) {
                Log.INSTANCE.warn("Informal item stack " + itemStack);
            }
        }
        return bl2;
    }

    public static final boolean isNotFull(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        return !ItemStackExtensionsKt.isEmpty(itemStack) && !ItemStackExtensionsKt.isFull(itemStack);
    }

    public static final int getRoom(@NotNull ItemStack itemStack) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        ItemType itemType = itemStack.getItemType();
        ItemLike itemLike = (ItemLike)itemType.getItem();
        PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        if ((n2 = new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize() - itemStack.getCount()) < 0) {
            Log.INSTANCE.warn("Informal item stack " + itemStack);
        }
        return n2;
    }

    public static final boolean stackableWith(@NotNull ItemStack itemStack, @NotNull ItemStack itemStack2) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)itemStack2, (String)"");
        ItemType itemType = itemStack.getItemType();
        ItemLike itemLike = (ItemLike)itemType.getItem();
        PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        return new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize() > 1 && Intrinsics.areEqual((Object)itemStack.getItemType(), (Object)itemStack2.getItemType()) || ItemStackExtensionsKt.isEmpty(itemStack) || ItemStackExtensionsKt.isEmpty(itemStack2);
    }

    @NotNull
    public static final net.minecraft.world.item.ItemStack getVanillaStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        return ItemTypeExtensionsKt.vanillaStackWithCount(itemStack.getItemType(), itemStack.getCount());
    }

    @NotNull
    public static final MutableItemStack empty(@NotNull MutableItemStack$Companion mutableItemStack$Companion) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack$Companion, (String)"");
        Item item = Items.AIR;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
        return new MutableItemStack(new ItemType(item, new PatchedDataComponentMap(Items.AIR.components()), DataComponentPatch.EMPTY, ItemTypeExtensionsKt$EMPTY$1.INSTANCE, false, false, null, 112, null), 0, null, 4, null);
    }

    public static final void setEmpty(@NotNull MutableItemStack mutableItemStack) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Item item = Items.AIR;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
        mutableItemStack.setItemType(new ItemType(item, new PatchedDataComponentMap(Items.AIR.components()), DataComponentPatch.EMPTY, ItemTypeExtensionsKt$EMPTY$1.INSTANCE, false, false, null, 112, null));
        mutableItemStack.setCount(0);
    }

    private static final void normalize(MutableItemStack mutableItemStack) {
        if (ItemTypeExtensionsKt.isEmpty(((ItemStack)mutableItemStack).getItemType()) || ((ItemStack)mutableItemStack).getCount() <= 0) {
            ItemStackExtensionsKt.setEmpty(mutableItemStack);
        }
    }

    public static final void swapWith(@NotNull MutableItemStack mutableItemStack, @NotNull MutableItemStack mutableItemStack2) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableItemStack2, (String)"");
        ItemType itemType = ((ItemStack)mutableItemStack2).getItemType();
        MutableItemStack mutableItemStack3 = mutableItemStack;
        mutableItemStack2.setItemType(((ItemStack)mutableItemStack).getItemType());
        mutableItemStack3.setItemType(itemType);
        int n2 = ((ItemStack)mutableItemStack2).getCount();
        mutableItemStack3 = mutableItemStack;
        mutableItemStack2.setCount(((ItemStack)mutableItemStack).getCount());
        mutableItemStack3.setCount(n2);
    }

    public static final void transferTo(@NotNull MutableItemStack mutableItemStack, @NotNull MutableItemStack mutableItemStack2) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableItemStack2, (String)"");
        ItemStackExtensionsKt.transferNTo(mutableItemStack, mutableItemStack2, ((ItemStack)mutableItemStack).getCount());
    }

    public static final void transferOneTo(@NotNull MutableItemStack mutableItemStack, @NotNull MutableItemStack mutableItemStack2) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableItemStack2, (String)"");
        ItemStackExtensionsKt.transferNTo(mutableItemStack, mutableItemStack2, 1);
    }

    public static final void transferNTo(@NotNull MutableItemStack mutableItemStack, @NotNull MutableItemStack mutableItemStack2, int n2) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableItemStack2, (String)"");
        if (!ItemStackExtensionsKt.stackableWith(mutableItemStack, mutableItemStack2)) {
            return;
        }
        Object object = mutableItemStack;
        int n3 = ((ItemStack)object).getCount();
        object = ((ItemStack)object).getItemType();
        ItemLike itemLike = (ItemLike)((ItemType)object).getItem();
        PatchedDataComponentMap patchedDataComponentMap = ((ItemType)object).getTag();
        if (patchedDataComponentMap == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
        }
        if (n3 > new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize() && !ItemStackExtensionsKt.isEmpty(mutableItemStack2)) {
            return;
        }
        if (ItemStackExtensionsKt.isEmpty(mutableItemStack)) {
            return;
        }
        if (ItemStackExtensionsKt.isEmpty(mutableItemStack2)) {
            mutableItemStack2.setItemType(((ItemStack)mutableItemStack).getItemType());
            mutableItemStack2.setCount(0);
        }
        object = ItemStackExtensionsKt.getVanillaStack(mutableItemStack2);
        Log.INSTANCE.trace("another is " + (net.minecraft.world.item.ItemStack)object);
        object = mutableItemStack;
        int n4 = ((ItemStack)object).getCount();
        object = ((ItemStack)object).getItemType();
        ItemLike itemLike2 = (ItemLike)((ItemType)object).getItem();
        PatchedDataComponentMap patchedDataComponentMap2 = ((ItemType)object).getTag();
        if (patchedDataComponentMap2 == null) {
            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
            Intrinsics.checkNotNull((Object)dataComponentMap);
            patchedDataComponentMap2 = (PatchedDataComponentMap)dataComponentMap;
        }
        if ((n2 = n4 > new net.minecraft.world.item.ItemStack(itemLike2, 1, patchedDataComponentMap2).getMaxStackSize() ? ((ItemStack)mutableItemStack).getCount() : RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)n2, (int)Math.min(((ItemStack)mutableItemStack).getCount(), ItemStackExtensionsKt.getRoom(mutableItemStack2))), (int)0)) == 0) {
            return;
        }
        MutableItemStack mutableItemStack3 = mutableItemStack;
        mutableItemStack3.setCount(((ItemStack)mutableItemStack3).getCount() - n2);
        MutableItemStack mutableItemStack4 = mutableItemStack2;
        mutableItemStack4.setCount(((ItemStack)mutableItemStack4).getCount() + n2);
        ItemStackExtensionsKt.normalize(mutableItemStack);
        ItemStackExtensionsKt.normalize(mutableItemStack2);
    }

    public static final void splitHalfTo(@NotNull MutableItemStack mutableItemStack, @NotNull MutableItemStack mutableItemStack2) {
        Intrinsics.checkNotNullParameter((Object)mutableItemStack, (String)"");
        Intrinsics.checkNotNullParameter((Object)mutableItemStack2, (String)"");
        ItemStackExtensionsKt.transferNTo(mutableItemStack, mutableItemStack2, ((ItemStack)mutableItemStack).getCount() - ((ItemStack)mutableItemStack).getCount() / 2);
    }
}

