/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import kotlin.Unit;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.anti_ad.mc.common.gui.NativeContext;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.ipnext.config.Tweaks;
import org.anti_ad.mc.ipnext.event.ClientEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ContainerScreenEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ScreenEventHandler;
import org.anti_ad.mc.ipnext.inventory.GeneralInventoryActions;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class ForgeEventHandler {
    @SubscribeEvent
    public void clientClick(ClientTickEvent.Pre pre) {
        ClientEventHandler.INSTANCE.onTickPre();
    }

    @SubscribeEvent
    public void clientClick(ClientTickEvent.Post post) {
        ClientEventHandler.INSTANCE.onTick();
    }

    @SubscribeEvent
    public void onPlayerLogInEvent(ClientPlayerNetworkEvent.LoggingIn loggingIn) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinGame();
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void joinWorld(LevelEvent.Load load) {
        if (VanillaUtil.INSTANCE.isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinGame();
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent itemCraftedEvent) {
        ClientEventHandler.INSTANCE.onCrafted();
    }

    @SubscribeEvent
    public void onInitGuiPost(ScreenEvent.Init.Post post) {
        ScreenEventHandler.INSTANCE.onScreenInit(post.getScreen(), abstractButton -> {
            post.addListener((GuiEventListener)abstractButton);
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void preScreenRender(ScreenEvent.Render.Pre pre) {
        ScreenEventHandler.INSTANCE.preRender(new NativeContext(pre.getGuiGraphics(), RenderPipelines.GUI_TEXTURED));
    }

    @SubscribeEvent
    public void postScreenRender(ScreenEvent.Render.Post post) {
        ScreenEventHandler.INSTANCE.postRender(new NativeContext(post.getGuiGraphics(), RenderPipelines.GUI_TEXTURED));
    }

    @SubscribeEvent
    public void onBackgroundRender(ScreenEvent.Render.Background background) {
        NativeContext nativeContext = new NativeContext(background.getGuiGraphics(), RenderPipelines.GUI_TEXTURED);
        ContainerScreenEventHandler.INSTANCE.onBackgroundRender(nativeContext, background.getMouseX(), background.getMouseY(), 0.0f);
    }

    @SubscribeEvent
    public void onForegroundRender(ContainerScreenEvent.Render.Foreground foreground) {
        NativeContext nativeContext = new NativeContext(foreground.getGuiGraphics(), RenderPipelines.GUI_TEXTURED);
        nativeContext.setOverlay(true);
        AbstractContainerScreen abstractContainerScreen = foreground.getContainerScreen();
        Matrix3x2fStack matrix3x2fStack = nativeContext.getNative().pose().pushMatrix();
        abstractContainerScreen = new Rectangle(abstractContainerScreen.getGuiLeft(), abstractContainerScreen.getGuiTop(), abstractContainerScreen.getXSize(), abstractContainerScreen.getYSize()).getTopLeft();
        nativeContext.getNative().pose().translate((float)(-abstractContainerScreen.getX()), (float)(-abstractContainerScreen.getY()), (Matrix3x2f)matrix3x2fStack);
        ContainerScreenEventHandler.INSTANCE.onForegroundRender(nativeContext, foreground.getMouseX(), foreground.getMouseY(), 0.0f);
        nativeContext.getNative().pose().popMatrix();
    }

    @SubscribeEvent
    public void onGuiKeyPressedPre(ScreenEvent.KeyPressed.Pre pre) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        InputConstants.Key key = InputConstants.getKey((KeyEvent)pre.getKeyEvent());
        if (Tweaks.INSTANCE.getPREVENT_CLOSE_GUI_DROP_ITEM().getBooleanValue() && (pre.getKeyCode() == 256 || Vanilla.INSTANCE.mc().options.keyInventory.isActiveAndMatches(key))) {
            GeneralInventoryActions.INSTANCE.handleCloseContainer();
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenEvent.Closing closing) {
        if (!VanillaUtil.INSTANCE.inGame()) {
            return;
        }
        ScreenEventHandler.INSTANCE.onScreenRemoved(closing.getScreen());
    }
}

