/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.anti_ad.mc.common.extensions.Kt_commonKt;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.ingame.VanillaAccessorsKt;
import org.anti_ad.mc.ipnext.item.NbtUtils$WrappedTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nNbtUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NbtUtils.kt\norg/anti_ad/mc/ipnext/item/NbtUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n+ 4 kt_common.kt\norg/anti_ad/mc/common/extensions/Kt_commonKt\n*L\n1#1,281:1\n1563#2:282\n1634#2,3:283\n1563#2:286\n1634#2,3:287\n1563#2:337\n1634#2,3:338\n70#3,14:290\n70#3,14:304\n42#3,12:319\n37#3:331\n89#3,4:332\n38#3:336\n87#4:318\n*S KotlinDebug\n*F\n+ 1 NbtUtils.kt\norg/anti_ad/mc/ipnext/item/NbtUtils\n*L\n91#1:282\n91#1:283,3\n92#1:286\n92#1:287,3\n71#1:337\n71#1:338,3\n120#1:290,14\n124#1:304,14\n262#1:319,12\n267#1:331\n267#1:332,4\n267#1:336\n153#1:318\n*E\n"})
public final class NbtUtils {
    @NotNull
    public static final NbtUtils INSTANCE = new NbtUtils();

    private NbtUtils() {
    }

    @Nullable
    public final Item getItemFromId(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"");
        DefaultedRegistry defaultedRegistry = BuiltInRegistries.ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"");
        return (Item)VanillaAccessorsKt.(getByIdentifier)(defaultedRegistry, resourceLocation);
    }

    @Nullable
    public final List getTagFromId(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        BuiltInRegistries.ITEM.getTags().forEach(arg_0 -> NbtUtils.getTagFromId$lambda$1(arg_0 -> NbtUtils.getTagFromId$lambda$0(resourceLocation, objectRef, arg_0), arg_0));
        return (List)objectRef.element;
    }

    public final int compareNbt(@Nullable CompoundTag object, @Nullable CompoundTag compoundTag) {
        Object object2;
        boolean bl;
        boolean bl2 = object == null;
        boolean bl3 = bl = compoundTag == null;
        if (bl2 != bl) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        if (object == null || compoundTag == null) {
            return 0;
        }
        Set set = object.getAllKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"");
        Object object3 = CollectionsKt.sorted((Iterable)set);
        Set set2 = compoundTag.getAllKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"");
        Object object4 = CollectionsKt.sorted((Iterable)set2);
        Object object5 = object3 = (Iterable)object3;
        Iterable iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object5 = object3.next();
            String string = (String)object5;
            object2 = iterable;
            object2.add(Kt_commonKt.asComparable((Object)TuplesKt.to((Object)string, (Object)object.get(string)), INSTANCE::compareStringTag));
        }
        object = (List)iterable;
        object3 = (Iterable)object4;
        iterable = object3;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        for (String string : iterable) {
            object4 = string;
            object2 = object3;
            object2.add(Kt_commonKt.asComparable((Object)TuplesKt.to((Object)object4, (Object)compoundTag.get((String)object4)), INSTANCE::compareStringTag));
        }
        object3 = (List)object3;
        return Kt_commonKt.compareTo((List)object, (List)object3);
    }

    private final int compareStringTag(kotlin.Pair pair, kotlin.Pair pair2) {
        String string = (String)pair.component1();
        pair = (Tag)pair.component2();
        String string2 = (String)pair2.component1();
        pair2 = (Tag)pair2.component2();
        int n2 = string.compareTo(string2);
        if (n2 != 0) {
            return n2;
        }
        if (pair == null || pair2 == null) {
            return 0;
        }
        return this.compareTo((Tag)pair, (Tag)pair2);
    }

    public final int compareTo(@NotNull Tag object, @NotNull Tag object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        object = new NbtUtils$WrappedTag((Tag)object);
        object2 = new NbtUtils$WrappedTag((Tag)object2);
        Integer n2 = ((NbtUtils$WrappedTag)object).isNumber() ? (((NbtUtils$WrappedTag)object2).isNumber() ? Integer.valueOf(Double.compare(((NbtUtils$WrappedTag)object).getAsDouble(), ((NbtUtils$WrappedTag)object2).getAsDouble())) : null) : (((NbtUtils$WrappedTag)object).isCompound() ? (((NbtUtils$WrappedTag)object2).isCompound() ? Integer.valueOf(this.compareNbt(((NbtUtils$WrappedTag)object).getAsCompound(), ((NbtUtils$WrappedTag)object2).getAsCompound())) : null) : (((NbtUtils$WrappedTag)object).isList() ? (((NbtUtils$WrappedTag)object2).isList() ? Integer.valueOf(Kt_commonKt.compareTo((List)((NbtUtils$WrappedTag)object).getAsListComparable(), (List)((NbtUtils$WrappedTag)object2).getAsListComparable())) : null) : null));
        if (n2 != null) {
            return n2;
        }
        return ((NbtUtils$WrappedTag)object).getAsString().compareTo(((NbtUtils$WrappedTag)object2).getAsString());
    }

    @Nullable
    public final CompoundTag parseNbt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            string = TagParser.parseTag((String)string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = null;
        }
        return string;
    }

    @NotNull
    public final Tag parseNbtOrEmpty(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            string = new TagParser(new StringReader(string)).readValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = null;
        }
        if ((string2 = string) == null) {
            string2 = (Tag)new CompoundTag();
        }
        return string2;
    }

    public final boolean matchNbtNoExtra(@Nullable Tag tag, @Nullable Tag tag2) {
        if (tag == null) {
            return true;
        }
        if (tag2 == null) {
            return false;
        }
        NbtUtils$WrappedTag nbtUtils$WrappedTag = new NbtUtils$WrappedTag(tag);
        NbtUtils$WrappedTag nbtUtils$WrappedTag2 = new NbtUtils$WrappedTag(tag2);
        if (!nbtUtils$WrappedTag.sameType(nbtUtils$WrappedTag2)) {
            return false;
        }
        if (nbtUtils$WrappedTag.isNumber()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsNumber(), (Object)nbtUtils$WrappedTag2.getAsNumber());
        }
        if (nbtUtils$WrappedTag.isString()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsString(), (Object)nbtUtils$WrappedTag2.getAsString());
        }
        if (nbtUtils$WrappedTag.isList()) {
            ListTag cfr_ignored_0 = (ListTag)tag;
            ListTag cfr_ignored_1 = (ListTag)tag2;
            return ((ListTag)tag).size() == ((ListTag)tag2).size() && ((ListTag)tag).containsAll((Collection)tag2);
        }
        CompoundTag cfr_ignored_2 = (CompoundTag)tag;
        CompoundTag cfr_ignored_3 = (CompoundTag)tag2;
        Object object = !((CompoundTag)tag).isEmpty() ? tag : null;
        tag = tag2;
        nbtUtils$WrappedTag = (CompoundTag)tag;
        tag2 = object;
        boolean bl = nbtUtils$WrappedTag.isEmpty();
        return Intrinsics.areEqual((Object)tag2, (Object)(!bl ? tag : null));
    }

    public final boolean matchNbt(@Nullable Tag tag, @Nullable Tag tag2) {
        if (tag == null) {
            return true;
        }
        if (tag2 == null) {
            return false;
        }
        NbtUtils$WrappedTag nbtUtils$WrappedTag = new NbtUtils$WrappedTag(tag);
        NbtUtils$WrappedTag nbtUtils$WrappedTag2 = new NbtUtils$WrappedTag(tag2);
        if (!nbtUtils$WrappedTag.sameType(nbtUtils$WrappedTag2)) {
            return false;
        }
        if (nbtUtils$WrappedTag.isNumber()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsNumber(), (Object)nbtUtils$WrappedTag2.getAsNumber());
        }
        if (nbtUtils$WrappedTag.isString()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsString(), (Object)nbtUtils$WrappedTag2.getAsString());
        }
        if (nbtUtils$WrappedTag.isList()) {
            ListTag cfr_ignored_0 = (ListTag)tag;
            ListTag cfr_ignored_1 = (ListTag)tag2;
            return ((ListTag)tag2).containsAll((Collection)tag);
        }
        CompoundTag cfr_ignored_2 = (CompoundTag)tag;
        CompoundTag cfr_ignored_3 = (CompoundTag)tag2;
        if (((CompoundTag)tag).isEmpty() && ((CompoundTag)tag2).isEmpty()) {
            return true;
        }
        if (((CompoundTag)tag2).isEmpty()) {
            return false;
        }
        return this.innerMatchNbt((CompoundTag)tag, (CompoundTag)tag2);
    }

    private final boolean innerMatchNbt(CompoundTag compoundTag, CompoundTag compoundTag2) {
        return net.minecraft.nbt.NbtUtils.compareNbt((Tag)((Tag)compoundTag), (Tag)((Tag)compoundTag2), (boolean)true);
    }

    private final NbtPathArgument.NbtPath getNbtPath(String string) {
        Log log = Log.INSTANCE;
        try {
            string = new NbtPathArgument().parse(new StringReader(string));
        }
        catch (Throwable throwable) {
            string = throwable.toString();
            log.warn(string);
            string = null;
        }
        return (NbtPathArgument.NbtPath)string;
    }

    private final List getTagsForPath(NbtPathArgument.NbtPath object, Tag tag) {
        List list = CollectionsKt.emptyList();
        try {
            List list2 = object.get(tag);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"");
            object = list2;
        }
        catch (Throwable throwable) {
            object = list;
        }
        return (List)object;
    }

    @Nullable
    public final Tag nullIfEmpty(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof CompoundTag && ((CompoundTag)tag).isEmpty() || tag instanceof ListTag && ((ListTag)tag).isEmpty()) {
            return null;
        }
        return tag;
    }

    private static final Unit getTagFromId$lambda$0(ResourceLocation object, Ref.ObjectRef object2, Pair object3) {
        if (Intrinsics.areEqual((Object)((TagKey)object3.getFirst()).location(), (Object)object)) {
            Object object4 = object3.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"");
            object = (Iterable)object4;
            Ref.ObjectRef objectRef = object2;
            object2 = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                object3 = (Holder)object3;
                Object object5 = object;
                object5.add((Item)object3.value());
            }
            objectRef.element = (List)object;
        }
        return Unit.INSTANCE;
    }

    private static final void getTagFromId$lambda$1(Function1 function1, Object object) {
        function1.invoke(object);
    }

    public static final /* synthetic */ NbtPathArgument.NbtPath access$getNbtPath(NbtUtils nbtUtils, String string) {
        return nbtUtils.getNbtPath(string);
    }

    public static final /* synthetic */ List access$getTagsForPath(NbtUtils nbtUtils, NbtPathArgument.NbtPath nbtPath, Tag tag) {
        return nbtUtils.getTagsForPath(nbtPath, tag);
    }
}

