/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.event;

import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.input.MainKeybind;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.config.GuiSettings;
import org.anti_ad.mc.ipnext.container.ExtensionsKt;
import org.anti_ad.mc.ipnext.ingame.VanillaAccessorsKt$(itemType)$1;
import org.anti_ad.mc.ipnext.inventory.AreaType;
import org.anti_ad.mc.ipnext.inventory.AreaTypes;
import org.anti_ad.mc.ipnext.inventory.ContainerClicker;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.anti_ad.mc.ipnext.item.ItemStackExtensionsKt;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nStoneCutterCraftingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoneCutterCraftingHandler.kt\norg/anti_ad/mc/ipnext/event/CutterCraftingHandlerBase\n+ 2 VanillaAccessors.kt\norg/anti_ad/mc/ipnext/ingame/VanillaAccessorsKt\n+ 3 ItemTypeExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemTypeExtensionsKt\n*L\n1#1,293:1\n76#2:294\n76#2:295\n86#2:296\n69#2:297\n64#2,7:298\n86#2:305\n69#2:306\n64#2,7:307\n82#2:314\n76#2,11:315\n69#2:326\n64#2,7:327\n76#2,11:334\n69#2:345\n64#2,7:346\n115#3:353\n*S KotlinDebug\n*F\n+ 1 StoneCutterCraftingHandler.kt\norg/anti_ad/mc/ipnext/event/CutterCraftingHandlerBase\n*L\n89#1:294\n131#1:295\n133#1:296\n133#1:297\n133#1:298,7\n137#1:305\n137#1:306\n137#1:307,7\n140#1:314\n178#1:315,11\n178#1:326\n178#1:327,7\n185#1:334,11\n185#1:345\n185#1:346,7\n195#1:353\n*E\n"})
public abstract class CutterCraftingHandlerBase {
    private boolean skipTick;
    private int waitForEmptyNumTicks;
    private boolean isCraftClick;
    private boolean stillCrafting;
    private boolean isRefillTick;
    private int lastRecipe = -1;
    @NotNull
    private ItemStack lastInput = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
    private int recipe = -1;
    protected ItemStack input;
    private boolean isNewScreen = true;
    @Nullable
    private AbstractContainerScreen currentScreen;
    @Nullable
    private AbstractContainerMenu currentContainer;
    @NotNull
    private final MainKeybind SHIFT = new MainKeybind("LEFT_SHIFT", KeybindSettings.Companion.getGUI_EXTRA());

    public CutterCraftingHandlerBase() {
        ExtensionsKt.setSelectPostAction(() -> CutterCraftingHandlerBase._init_$lambda$0(this));
        ExtensionsKt.setSelectPreAction(() -> CutterCraftingHandlerBase._init_$lambda$1(this));
    }

    public final boolean getSkipTick() {
        return this.skipTick;
    }

    public final int getWaitForEmptyNumTicks() {
        return this.waitForEmptyNumTicks;
    }

    protected final boolean isCraftClick() {
        return this.isCraftClick;
    }

    protected final void setCraftClick(boolean bl) {
        this.isCraftClick = bl;
    }

    public final boolean getStillCrafting() {
        return this.stillCrafting;
    }

    public final void setStillCrafting(boolean bl) {
        this.stillCrafting = bl;
    }

    public final boolean isRefillTick() {
        return this.isRefillTick;
    }

    public final void setRefillTick(boolean bl) {
        this.isRefillTick = bl;
    }

    @NotNull
    protected final ItemStack getInput() {
        ItemStack itemStack = this.input;
        if (itemStack != null) {
            return itemStack;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    protected final void setInput(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        this.input = itemStack;
    }

    private final boolean getEnabled() {
        return GuiSettings.INSTANCE.getCONTINUOUS_CRAFTING_SAVED_VALUE().getBooleanValue();
    }

    public final boolean isNewScreen() {
        return this.isNewScreen;
    }

    protected final void setNewScreen(boolean bl) {
        this.isNewScreen = bl;
    }

    @NotNull
    protected final MainKeybind getSHIFT() {
        return this.SHIFT;
    }

    @NotNull
    public final List getPlayerSlotIndices() {
        AbstractContainerMenu abstractContainerMenu = this.currentContainer;
        if (abstractContainerMenu != null) {
            AreaTypes areaTypes = AreaTypes.INSTANCE;
            AreaType areaType = areaTypes.getPlayerStorage().plus(areaTypes.getPlayerHotbar()).plus(areaTypes.getPlayerOffhand()).minus(areaTypes.getLockedSlots());
            AbstractContainerMenu abstractContainerMenu2 = abstractContainerMenu;
            NonNullList nonNullList = abstractContainerMenu2.slots;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"");
            return areaType.getItemArea(abstractContainerMenu2, (List)nonNullList).getSlotIndices();
        }
        return CollectionsKt.emptyList();
    }

    public abstract void typeSpecificOnTickInGame(@NotNull AbstractContainerScreen var1);

    public abstract void typeSpecificNewContainer(@NotNull AbstractContainerScreen var1);

    public abstract void selectRecipe(@NotNull AbstractContainerMenu var1, int var2);

    public abstract int selectedRecipe(@NotNull AbstractContainerMenu var1);

    @Nullable
    public abstract Integer selectedRecipeOrNull(@Nullable AbstractContainerMenu var1);

    public final void onTickBase() {
        block23: {
            block22: {
                Screen screen;
                block24: {
                    Object object;
                    block26: {
                        block25: {
                            if (this.skipTick) {
                                return;
                            }
                            screen = Vanilla.INSTANCE.screen();
                            if (screen == null) break block22;
                            if (!this.getEnabled() || !(screen instanceof AbstractContainerScreen)) break block23;
                            if (this.stillCrafting && !this.isRefillTick) {
                                Log.INSTANCE.trace("Still crafting");
                                this.typeSpecificOnTickInGame((AbstractContainerScreen)screen);
                                this.stillCrafting = false;
                                return;
                            }
                            if (this.isCraftClick) {
                                Log.INSTANCE.trace("craft click");
                                ContainerClicker.INSTANCE.shiftClick(1);
                                this.isCraftClick = false;
                                return;
                            }
                            if (!this.isRefillTick) break block24;
                            Log.INSTANCE.trace("refill tick");
                            object = this.currentContainer;
                            if (object == null) break block25;
                            NonNullList nonNullList = object.slots;
                            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"");
                            object = (List)nonNullList;
                            if (object != null) break block26;
                        }
                        object = screen = CollectionsKt.emptyList();
                    }
                    if (!((Collection)object).isEmpty()) {
                        ItemStack itemStack;
                        net.minecraft.world.item.ItemStack itemStack2 = ((Slot)screen.get(0)).getItem();
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"");
                        Object object2 = itemStack2;
                        if (itemStack2.isEmpty()) {
                            itemStack = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
                        } else {
                            Object object3 = object2;
                            Item item = object3.getItem();
                            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
                            DataComponentMap dataComponentMap = object3.getComponents();
                            Intrinsics.checkNotNull((Object)dataComponentMap);
                            itemStack = ItemStack.Companion.invoke(new ItemType(item, (PatchedDataComponentMap)dataComponentMap, object3.getComponentsPatch(), new VanillaAccessorsKt$(itemType)$1((net.minecraft.world.item.ItemStack)object3), false, false, null, 112, null), object2.getCount());
                        }
                        this.setInput(itemStack);
                        if (ItemStackExtensionsKt.isEmpty(this.getInput())) {
                            Object object4;
                            block21: {
                                this.waitForEmptyNumTicks = 0;
                                for (Object object3 : (Iterable)this.getPlayerSlotIndices()) {
                                    ItemStack itemStack3;
                                    int n2 = ((Number)object3).intValue();
                                    Intrinsics.checkNotNullExpressionValue((Object)((Slot)screen.get(n2)).getItem(), (String)"");
                                    if (object2.isEmpty()) {
                                        itemStack3 = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
                                    } else {
                                        Object object5 = object2;
                                        Item item = object5.getItem();
                                        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
                                        DataComponentMap dataComponentMap = object5.getComponents();
                                        Intrinsics.checkNotNull((Object)dataComponentMap);
                                        itemStack3 = ItemStack.Companion.invoke(new ItemType(item, (PatchedDataComponentMap)dataComponentMap, object5.getComponentsPatch(), new VanillaAccessorsKt$(itemType)$1((net.minecraft.world.item.ItemStack)object5), false, false, null, 112, null), object2.getCount());
                                    }
                                    if (!Intrinsics.areEqual((Object)itemStack3.getItemType(), (Object)this.lastInput.getItemType())) continue;
                                    object4 = object3;
                                    break block21;
                                }
                                object4 = null;
                            }
                            object2 = (Integer)object4;
                            if (object2 != null) {
                                int n3 = ((Number)object2).intValue();
                                Log.INSTANCE.trace("will shift click on slot " + n3);
                                ContainerClicker.INSTANCE.shiftClick(((Slot)screen.get((int)n3)).index);
                            }
                        } else {
                            int n4 = this.waitForEmptyNumTicks;
                            this.waitForEmptyNumTicks = n4 + 1;
                            if (this.waitForEmptyNumTicks > 2) {
                                this.waitForEmptyNumTicks = 0;
                                Log.INSTANCE.trace("did not find empty slot, will stop refill");
                            } else {
                                return;
                            }
                        }
                        int n5 = this.lastRecipe;
                        AbstractContainerMenu abstractContainerMenu = this.currentContainer;
                        if (abstractContainerMenu != null) {
                            AbstractContainerMenu abstractContainerMenu2 = abstractContainerMenu;
                            this.selectRecipe(abstractContainerMenu2, n5);
                        }
                    }
                    this.isRefillTick = false;
                    return;
                }
                if (this.isNewScreen) {
                    this.typeSpecificNewContainer((AbstractContainerScreen)screen);
                    return;
                }
                this.checkChanged();
                return;
            }
            this.isNewScreen = true;
            this.currentContainer = null;
            this.currentScreen = null;
            this.setInput(ItemStackExtensionsKt.getEMPTY(ItemStack.Companion));
            this.recipe = -1;
        }
    }

    protected final void init(@NotNull AbstractContainerScreen abstractContainerScreen, @NotNull AbstractContainerMenu abstractContainerMenu) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)abstractContainerScreen, (String)"");
        Intrinsics.checkNotNullParameter((Object)abstractContainerMenu, (String)"");
        this.currentContainer = abstractContainerMenu;
        this.currentScreen = abstractContainerScreen;
        NonNullList nonNullList = abstractContainerMenu.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"");
        net.minecraft.world.item.ItemStack itemStack2 = ((Slot)((List)nonNullList).get(0)).getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"");
        abstractContainerScreen = itemStack2;
        if (itemStack2.isEmpty()) {
            itemStack = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
        } else {
            AbstractContainerScreen abstractContainerScreen2 = abstractContainerScreen;
            Item item = abstractContainerScreen2.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
            DataComponentMap dataComponentMap = abstractContainerScreen2.getComponents();
            Intrinsics.checkNotNull((Object)dataComponentMap);
            itemStack = ItemStack.Companion.invoke(new ItemType(item, (PatchedDataComponentMap)dataComponentMap, abstractContainerScreen2.getComponentsPatch(), new VanillaAccessorsKt$(itemType)$1((net.minecraft.world.item.ItemStack)abstractContainerScreen2), false, false, null, 112, null), abstractContainerScreen.getCount());
        }
        this.setInput(itemStack);
        this.recipe = this.selectedRecipe(abstractContainerMenu);
    }

    private final void checkChanged() {
        Object object;
        CutterCraftingHandlerBase cutterCraftingHandlerBase;
        block6: {
            block5: {
                Object object2;
                this.lastInput = this.getInput();
                this.lastRecipe = this.recipe;
                cutterCraftingHandlerBase = this;
                object = cutterCraftingHandlerBase.currentContainer;
                if (object == null) break block5;
                NonNullList nonNullList = ((AbstractContainerMenu)object).slots;
                Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"");
                object = (List)nonNullList;
                if (object == null || (object = (Slot)object.get(0)) == null) break block5;
                net.minecraft.world.item.ItemStack itemStack = object.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"");
                net.minecraft.world.item.ItemStack itemStack2 = itemStack;
                if (itemStack.isEmpty()) {
                    object2 = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
                } else {
                    net.minecraft.world.item.ItemStack itemStack3 = itemStack2;
                    Item item = itemStack3.getItem();
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"");
                    DataComponentMap dataComponentMap = itemStack3.getComponents();
                    Intrinsics.checkNotNull((Object)dataComponentMap);
                    object2 = object = ItemStack.Companion.invoke(new ItemType(item, (PatchedDataComponentMap)dataComponentMap, itemStack3.getComponentsPatch(), new VanillaAccessorsKt$(itemType)$1(itemStack3), false, false, null, 112, null), itemStack2.getCount());
                }
                if (object2 != null) break block6;
            }
            object = ItemStackExtensionsKt.getEMPTY(ItemStack.Companion);
        }
        cutterCraftingHandlerBase.setInput((ItemStack)object);
        Integer n2 = this.selectedRecipeOrNull(this.currentContainer);
        this.recipe = n2 != null ? n2 : -1;
    }

    public final void onCraftedSink() {
        if (this.stillCrafting) {
            return;
        }
        Log.INSTANCE.traceIf(() -> CutterCraftingHandlerBase.onCraftedSink$lambda$6(this));
        this.isRefillTick = true;
        this.stillCrafting = true;
    }

    private static final Unit _init_$lambda$0(CutterCraftingHandlerBase cutterCraftingHandlerBase) {
        cutterCraftingHandlerBase.skipTick = false;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CutterCraftingHandlerBase cutterCraftingHandlerBase) {
        cutterCraftingHandlerBase.skipTick = true;
        return Unit.INSTANCE;
    }

    private static final Unit onCraftedSink$lambda$6(CutterCraftingHandlerBase cutterCraftingHandlerBase) {
        ItemType itemType = cutterCraftingHandlerBase.getInput().getItemType();
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)itemType.getItem());
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"");
        Log.INSTANCE.trace("input type: " + resourceLocation);
        Log.INSTANCE.trace("input recipe: " + cutterCraftingHandlerBase.recipe);
        return Unit.INSTANCE;
    }
}

