/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item;

import com.mojang.brigadier.StringReader;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.anti_ad.mc.common.extensions.Kt_commonKt;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.ingame.VanillaAccessorsKt;
import org.anti_ad.mc.ipnext.item.NbtUtils$WrappedTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nNbtUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NbtUtils.kt\norg/anti_ad/mc/ipnext/item/NbtUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n+ 5 kt_common.kt\norg/anti_ad/mc/common/extensions/Kt_commonKt\n*L\n1#1,276:1\n183#2,2:277\n1563#3:279\n1634#3,3:280\n1563#3:283\n1634#3,3:284\n1563#3:287\n1634#3,3:288\n70#4,14:291\n70#4,14:305\n42#4,12:320\n37#4:332\n89#4,4:333\n38#4:337\n87#5:319\n*S KotlinDebug\n*F\n+ 1 NbtUtils.kt\norg/anti_ad/mc/ipnext/item/NbtUtils\n*L\n67#1:277,2\n69#1:279\n69#1:280,3\n86#1:283\n86#1:284,3\n87#1:287\n87#1:288,3\n115#1:291,14\n119#1:305,14\n257#1:320,12\n262#1:332\n262#1:333,4\n262#1:337\n148#1:319\n*E\n"})
public final class NbtUtils {
    @NotNull
    public static final NbtUtils INSTANCE = new NbtUtils();

    private NbtUtils() {
    }

    @Nullable
    public final Item getItemFromId(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"");
        DefaultedRegistry defaultedRegistry = BuiltInRegistries.ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"");
        return (Item)VanillaAccessorsKt.(getByIdentifier)(defaultedRegistry, resourceLocation);
    }

    @Nullable
    public final List getTagFromId(@NotNull ResourceLocation object) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Iterator iterator = BuiltInRegistries.ITEM.getTags().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"");
            for (Object object2 : SequencesKt.asSequence(iterator)) {
                if (!Intrinsics.areEqual((Object)((HolderSet.Named)object2).key().location(), (Object)object)) continue;
                v1 = object2;
                break block3;
            }
            v1 = null;
        }
        object = v1;
        if (object != null) {
            Object object2;
            Object object3 = object2 = (Iterable)object;
            object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
            object = object3.iterator();
            while (object.hasNext()) {
                object3 = object.next();
                object3 = (Holder)object3;
                Object e2 = object2;
                e2.add((Item)((Item)object3.value()));
            }
            return (List)object2;
        }
        return null;
    }

    public final int compareNbt(@Nullable CompoundTag object, @Nullable CompoundTag compoundTag) {
        Object object2;
        boolean bl;
        boolean bl2 = object == null;
        boolean bl3 = bl = compoundTag == null;
        if (bl2 != bl) {
            if (bl2) {
                return -1;
            }
            return 1;
        }
        if (object == null || compoundTag == null) {
            return 0;
        }
        Set set = object.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"");
        Object object3 = CollectionsKt.sorted((Iterable)set);
        Set set2 = compoundTag.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"");
        Object object4 = CollectionsKt.sorted((Iterable)set2);
        Object object5 = object3 = (Iterable)object3;
        Iterable iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object5 = object3.next();
            String string = (String)object5;
            object2 = iterable;
            object2.add(Kt_commonKt.asComparable((Object)TuplesKt.to((Object)string, (Object)object.get(string)), INSTANCE::compareStringTag));
        }
        object = (List)iterable;
        object3 = (Iterable)object4;
        iterable = object3;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        for (String string : iterable) {
            object4 = string;
            object2 = object3;
            object2.add(Kt_commonKt.asComparable((Object)TuplesKt.to((Object)object4, (Object)compoundTag.get((String)object4)), INSTANCE::compareStringTag));
        }
        object3 = (List)object3;
        return Kt_commonKt.compareTo((List)object, (List)object3);
    }

    private final int compareStringTag(Pair pair, Pair pair2) {
        String string = (String)pair.component1();
        pair = (Tag)pair.component2();
        String string2 = (String)pair2.component1();
        pair2 = (Tag)pair2.component2();
        int n2 = string.compareTo(string2);
        if (n2 != 0) {
            return n2;
        }
        if (pair == null || pair2 == null) {
            return 0;
        }
        return this.compareTo((Tag)pair, (Tag)pair2);
    }

    public final int compareTo(@NotNull Tag object, @NotNull Tag object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        object = new NbtUtils$WrappedTag((Tag)object);
        object2 = new NbtUtils$WrappedTag((Tag)object2);
        Integer n2 = ((NbtUtils$WrappedTag)object).isNumber() ? (((NbtUtils$WrappedTag)object2).isNumber() ? Integer.valueOf(Double.compare(((NbtUtils$WrappedTag)object).getAsDouble(), ((NbtUtils$WrappedTag)object2).getAsDouble())) : null) : (((NbtUtils$WrappedTag)object).isCompound() ? (((NbtUtils$WrappedTag)object2).isCompound() ? Integer.valueOf(this.compareNbt(((NbtUtils$WrappedTag)object).getAsCompound(), ((NbtUtils$WrappedTag)object2).getAsCompound())) : null) : (((NbtUtils$WrappedTag)object).isList() ? (((NbtUtils$WrappedTag)object2).isList() ? Integer.valueOf(Kt_commonKt.compareTo((List)((NbtUtils$WrappedTag)object).getAsListComparable(), (List)((NbtUtils$WrappedTag)object2).getAsListComparable())) : null) : null));
        if (n2 != null) {
            return n2;
        }
        return ((NbtUtils$WrappedTag)object).getAsString().compareTo(((NbtUtils$WrappedTag)object2).getAsString());
    }

    @Nullable
    public final CompoundTag parseNbt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            string = TagParser.parseCompoundFully((String)string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = null;
        }
        return string;
    }

    @NotNull
    public final Tag parseNbtOrEmpty(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            string = (Tag)TagParser.create((DynamicOps)((DynamicOps)NbtOps.INSTANCE)).parseFully(new StringReader(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            string = null;
        }
        if ((string2 = string) == null) {
            string2 = (Tag)new CompoundTag();
        }
        return string2;
    }

    public final boolean matchNbtNoExtra(@Nullable Tag tag, @Nullable Tag tag2) {
        if (tag == null) {
            return true;
        }
        if (tag2 == null) {
            return false;
        }
        NbtUtils$WrappedTag nbtUtils$WrappedTag = new NbtUtils$WrappedTag(tag);
        NbtUtils$WrappedTag nbtUtils$WrappedTag2 = new NbtUtils$WrappedTag(tag2);
        if (!nbtUtils$WrappedTag.sameType(nbtUtils$WrappedTag2)) {
            return false;
        }
        if (nbtUtils$WrappedTag.isNumber()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsNumber(), (Object)nbtUtils$WrappedTag2.getAsNumber());
        }
        if (nbtUtils$WrappedTag.isString()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsString(), (Object)nbtUtils$WrappedTag2.getAsString());
        }
        if (nbtUtils$WrappedTag.isList()) {
            ListTag cfr_ignored_0 = (ListTag)tag;
            ListTag cfr_ignored_1 = (ListTag)tag2;
            return ((ListTag)tag).size() == ((ListTag)tag2).size() && ((ListTag)tag).containsAll((Collection)tag2);
        }
        CompoundTag cfr_ignored_2 = (CompoundTag)tag;
        CompoundTag cfr_ignored_3 = (CompoundTag)tag2;
        Object object = !((CompoundTag)tag).isEmpty() ? tag : null;
        tag = tag2;
        nbtUtils$WrappedTag = (CompoundTag)tag;
        tag2 = object;
        boolean bl = nbtUtils$WrappedTag.isEmpty();
        return Intrinsics.areEqual((Object)tag2, (Object)(!bl ? tag : null));
    }

    public final boolean matchNbt(@Nullable Tag tag, @Nullable Tag tag2) {
        if (tag == null) {
            return true;
        }
        if (tag2 == null) {
            return false;
        }
        NbtUtils$WrappedTag nbtUtils$WrappedTag = new NbtUtils$WrappedTag(tag);
        NbtUtils$WrappedTag nbtUtils$WrappedTag2 = new NbtUtils$WrappedTag(tag2);
        if (!nbtUtils$WrappedTag.sameType(nbtUtils$WrappedTag2)) {
            return false;
        }
        if (nbtUtils$WrappedTag.isNumber()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsNumber(), (Object)nbtUtils$WrappedTag2.getAsNumber());
        }
        if (nbtUtils$WrappedTag.isString()) {
            return Intrinsics.areEqual((Object)nbtUtils$WrappedTag.getAsString(), (Object)nbtUtils$WrappedTag2.getAsString());
        }
        if (nbtUtils$WrappedTag.isList()) {
            ListTag cfr_ignored_0 = (ListTag)tag;
            ListTag cfr_ignored_1 = (ListTag)tag2;
            return ((ListTag)tag2).containsAll((Collection)tag);
        }
        CompoundTag cfr_ignored_2 = (CompoundTag)tag;
        CompoundTag cfr_ignored_3 = (CompoundTag)tag2;
        if (((CompoundTag)tag).isEmpty() && ((CompoundTag)tag2).isEmpty()) {
            return true;
        }
        if (((CompoundTag)tag2).isEmpty()) {
            return false;
        }
        return this.innerMatchNbt((CompoundTag)tag, (CompoundTag)tag2);
    }

    private final boolean innerMatchNbt(CompoundTag compoundTag, CompoundTag compoundTag2) {
        return net.minecraft.nbt.NbtUtils.compareNbt((Tag)((Tag)compoundTag), (Tag)((Tag)compoundTag2), (boolean)true);
    }

    private final NbtPathArgument.NbtPath getNbtPath(String string) {
        Log log = Log.INSTANCE;
        try {
            string = new NbtPathArgument().parse(new StringReader(string));
        }
        catch (Throwable throwable) {
            string = throwable.toString();
            log.warn(string);
            string = null;
        }
        return (NbtPathArgument.NbtPath)string;
    }

    private final List getTagsForPath(NbtPathArgument.NbtPath object, Tag tag) {
        List list = CollectionsKt.emptyList();
        try {
            List list2 = object.get(tag);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"");
            object = list2;
        }
        catch (Throwable throwable) {
            object = list;
        }
        return (List)object;
    }

    @Nullable
    public final Tag nullIfEmpty(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof CompoundTag && ((CompoundTag)tag).isEmpty() || tag instanceof ListTag && ((ListTag)tag).isEmpty()) {
            return null;
        }
        return tag;
    }

    public static final /* synthetic */ NbtPathArgument.NbtPath access$getNbtPath(NbtUtils nbtUtils, String string) {
        return nbtUtils.getNbtPath(string);
    }

    public static final /* synthetic */ List access$getTagsForPath(NbtUtils nbtUtils, NbtPathArgument.NbtPath nbtPath, Tag tag) {
        return nbtUtils.getTagsForPath(nbtPath, tag);
    }
}

