/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hypercrafting.fluid;

import net.mcreator.hypercrafting.init.HyperCraftingModBlocks;
import net.mcreator.hypercrafting.init.HyperCraftingModFluidTypes;
import net.mcreator.hypercrafting.init.HyperCraftingModFluids;
import net.mcreator.hypercrafting.init.HyperCraftingModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class StygianWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)HyperCraftingModFluidTypes.STYGIAN_WATER_TYPE.get(), () -> (Fluid)HyperCraftingModFluids.STYGIAN_WATER.get(), () -> (Fluid)HyperCraftingModFluids.FLOWING_STYGIAN_WATER.get()).explosionResistance(100.0f).tickRate(10).levelDecreasePerBlock(2).slopeFindDistance(2).bucket(() -> (Item)HyperCraftingModItems.STYGIAN_WATER_BUCKET.get()).block(() -> (LiquidBlock)HyperCraftingModBlocks.STYGIAN_WATER.get());

    private StygianWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.SOUL_FIRE_FLAME;
    }

    public static class Flowing
    extends StygianWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends StygianWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

