/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hypercrafting.init;

import net.mcreator.hypercrafting.potion.AAarghMobEffect;
import net.mcreator.hypercrafting.potion.BIGMobEffect;
import net.mcreator.hypercrafting.potion.CatalyzedMobEffect;
import net.mcreator.hypercrafting.potion.DeathLmaoMobEffect;
import net.mcreator.hypercrafting.potion.SmallMobEffect;
import net.mcreator.hypercrafting.procedures.DeathMarkProcedure;
import net.mcreator.hypercrafting.procedures.GoBackProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class HyperCraftingModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"hyper_crafting");
    public static final DeferredHolder<MobEffect, MobEffect> A_AARGH = REGISTRY.register("a_aargh", () -> new AAarghMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CATALYZED = REGISTRY.register("catalyzed", () -> new CatalyzedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEATH_LMAO = REGISTRY.register("death_lmao", () -> new DeathLmaoMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BIG = REGISTRY.register("big", () -> new BIGMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SMALL = REGISTRY.register("small", () -> new SmallMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            HyperCraftingModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            HyperCraftingModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(CATALYZED)) {
            GoBackProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getZ(), entity);
        } else if (effectInstance.getEffect().is(DEATH_LMAO)) {
            DeathMarkProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        }
    }
}

