/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hypercrafting.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.hypercrafting.init.HyperCraftingModBlockEntities;
import net.mcreator.hypercrafting.world.inventory.SigmaaMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class DoubleHeightThingyBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)72, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private final EnergyStorage energyStorage = new EnergyStorage(1000000, 1000, 999, 1000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                DoubleHeightThingyBlockEntity.this.setChanged();
                DoubleHeightThingyBlockEntity.this.level.sendBlockUpdated(DoubleHeightThingyBlockEntity.this.worldPosition, DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                DoubleHeightThingyBlockEntity.this.setChanged();
                DoubleHeightThingyBlockEntity.this.level.sendBlockUpdated(DoubleHeightThingyBlockEntity.this.worldPosition, DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    private final FluidTank fluidTank = new FluidTank(8000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            DoubleHeightThingyBlockEntity.this.setChanged();
            DoubleHeightThingyBlockEntity.this.level.sendBlockUpdated(DoubleHeightThingyBlockEntity.this.worldPosition, DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), DoubleHeightThingyBlockEntity.this.level.getBlockState(DoubleHeightThingyBlockEntity.this.worldPosition), 2);
        }
    };

    public DoubleHeightThingyBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)HyperCraftingModBlockEntities.DOUBLE_HEIGHT_THINGY.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        if ((tag = compound.get("fluidTank")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(lookupProvider, compoundTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        compound.put("fluidTank", (Tag)this.fluidTank.writeToNBT(lookupProvider, new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"double_height_thingy");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new SigmaaMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Adamantium Storage Container");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

