/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.init;

import cheesemod.entity.BazookaCheeseProjectileEntity;
import cheesemod.entity.BetterCheeseBossEntity;
import cheesemod.entity.BlueBazookaCheeseAmmoProjectileEntity;
import cheesemod.entity.BlueCheeseAmmoProjectileEntity;
import cheesemod.entity.CheeseBossEntity;
import cheesemod.entity.CheeseGunProjectileEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CheesemodModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cheesemod");
    public static final DeferredHolder<EntityType<?>, EntityType<CheeseBossEntity>> CHEESE_BOSS = CheesemodModEntities.register("cheese_boss", EntityType.Builder.of(CheeseBossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(40).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CheeseGunProjectileEntity>> CHEESE_GUN_PROJECTILE = CheesemodModEntities.register("cheese_gun_projectile", EntityType.Builder.of(CheeseGunProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<BazookaCheeseProjectileEntity>> BAZOOKA_CHEESE_PROJECTILE = CheesemodModEntities.register("bazooka_cheese_projectile", EntityType.Builder.of(BazookaCheeseProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlueCheeseAmmoProjectileEntity>> BLUE_CHEESE_AMMO_PROJECTILE = CheesemodModEntities.register("blue_cheese_ammo_projectile", EntityType.Builder.of(BlueCheeseAmmoProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlueBazookaCheeseAmmoProjectileEntity>> BLUE_BAZOOKA_CHEESE_AMMO_PROJECTILE = CheesemodModEntities.register("blue_bazooka_cheese_ammo_projectile", EntityType.Builder.of(BlueBazookaCheeseAmmoProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<BetterCheeseBossEntity>> BETTER_CHEESE_BOSS = CheesemodModEntities.register("better_cheese_boss", EntityType.Builder.of(BetterCheeseBossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(40).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cheesemod", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        CheeseBossEntity.init(event);
        BetterCheeseBossEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CHEESE_BOSS.get(), CheeseBossEntity.createAttributes().build());
        event.put((EntityType)BETTER_CHEESE_BOSS.get(), BetterCheeseBossEntity.createAttributes().build());
    }
}

