/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.item;

import cheesemod.procedures.BlueCheeseArmorBootsTickEventProcedure;
import cheesemod.procedures.BlueCheeseArmorChestplateTickEventProcedure;
import cheesemod.procedures.BlueCheeseArmorHelmetTickEventProcedure;
import cheesemod.procedures.BlueCheeseArmorLeggingsTickEventProcedure;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class BlueCheeseArmorItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(36, Map.of(ArmorType.BOOTS, 5, ArmorType.LEGGINGS, 9, ArmorType.CHESTPLATE, 11, ArmorType.HELMET, 5, ArmorType.BODY, 11), 25, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"block.honey_block.break")), 5.0f, 0.1f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"cheesemod:blue_cheese_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"cheesemod:blue_cheese_armor")));

    private BlueCheeseArmorItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends BlueCheeseArmorItem {
        public Boots(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    BlueCheeseArmorBootsTickEventProcedure.execute((LevelAccessor)world, entity);
                }
            }
        }
    }

    public static class Leggings
    extends BlueCheeseArmorItem {
        public Leggings(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    BlueCheeseArmorLeggingsTickEventProcedure.execute((LevelAccessor)world, entity);
                }
            }
        }
    }

    public static class Chestplate
    extends BlueCheeseArmorItem {
        public Chestplate(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    BlueCheeseArmorChestplateTickEventProcedure.execute((LevelAccessor)world, entity);
                }
            }
        }
    }

    public static class Helmet
    extends BlueCheeseArmorItem {
        public Helmet(Item.Properties properties) {
            super(properties.fireResistant().humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
            super.inventoryTick(itemstack, world, entity, equipmentSlot);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (equipmentSlot != null && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                    BlueCheeseArmorHelmetTickEventProcedure.execute((LevelAccessor)world, entity);
                }
            }
        }
    }
}

