/*
 * Decompiled with CFR 0.152.
 */
package cheesemod;

import cheesemod.init.CheesemodModBlocks;
import cheesemod.init.CheesemodModEntities;
import cheesemod.init.CheesemodModFeatures;
import cheesemod.init.CheesemodModFluids;
import cheesemod.init.CheesemodModItems;
import cheesemod.init.CheesemodModMenus;
import cheesemod.init.CheesemodModStructures;
import cheesemod.init.CheesemodModTabs;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cheesemod")
public class CheesemodMod {
    public static final Logger LOGGER = LogManager.getLogger(CheesemodMod.class);
    public static final String MODID = "cheesemod";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("cheesemod", "cheesemod"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CheesemodMod() {
        MinecraftForge.EVENT_BUS.register((Object)new CheesemodModFMLBusEvents(this));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CheesemodModTabs.load();
        CheesemodModBlocks.REGISTRY.register(bus);
        CheesemodModItems.REGISTRY.register(bus);
        CheesemodModEntities.REGISTRY.register(bus);
        CheesemodModFeatures.REGISTRY.register(bus);
        CheesemodModFluids.REGISTRY.register(bus);
        CheesemodModStructures.REGISTRY.register(bus);
        CheesemodModMenus.REGISTRY.register(bus);
        bus.register((Object)this);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    private static class CheesemodModFMLBusEvents {
        private final CheesemodMod parent;

        CheesemodModFMLBusEvents(CheesemodMod parent) {
            this.parent = parent;
        }

        @SubscribeEvent
        public void tick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ArrayList actions = new ArrayList();
                workQueue.forEach(work -> {
                    work.setValue((Integer)work.getValue() - 1);
                    if ((Integer)work.getValue() == 0) {
                        actions.add(work);
                    }
                });
                actions.forEach(e -> ((Runnable)e.getKey()).run());
                workQueue.removeAll(actions);
            }
        }
    }
}

