/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.init;

import cheesemod.world.features.ores.CheeseOreFeature;
import cheesemod.world.features.ores.DirtBlockButBetterFeature;
import cheesemod.world.features.ores.GrassBlockButBetterFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class CheesemodModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"cheesemod");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> GRASS_BLOCK_BUT_BETTER = CheesemodModFeatures.register("grass_block_but_better", GrassBlockButBetterFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, GrassBlockButBetterFeature.GENERATE_BIOMES, GrassBlockButBetterFeature::configuredFeature));
    public static final RegistryObject<Feature<?>> CHEESE_ORE = CheesemodModFeatures.register("cheese_ore", CheeseOreFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, CheeseOreFeature.GENERATE_BIOMES, CheeseOreFeature::configuredFeature));
    public static final RegistryObject<Feature<?>> DIRT_BLOCK_BUT_BETTER = CheesemodModFeatures.register("dirt_block_but_better", DirtBlockButBetterFeature::feature, new FeatureRegistration(GenerationStage.Decoration.UNDERGROUND_ORES, DirtBlockButBetterFeature.GENERATE_BIOMES, DirtBlockButBetterFeature::configuredFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.configuredFeature());
        }
    }

    private static class FeatureRegistration {
        private final GenerationStage.Decoration stage;
        private final Set<ResourceLocation> biomes;
        private final Supplier<ConfiguredFeature<?, ?>> configuredFeature;

        public FeatureRegistration(GenerationStage.Decoration stage, Set<ResourceLocation> biomes, Supplier<ConfiguredFeature<?, ?>> configuredFeature) {
            this.stage = stage;
            this.biomes = biomes;
            this.configuredFeature = configuredFeature;
        }

        public GenerationStage.Decoration stage() {
            return this.stage;
        }

        public Set<ResourceLocation> biomes() {
            return this.biomes;
        }

        public Supplier<ConfiguredFeature<?, ?>> configuredFeature() {
            return this.configuredFeature;
        }
    }
}

