/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.item;

import cheesemod.init.CheesemodModItems;
import cheesemod.init.CheesemodModTabs;
import cheesemod.procedures.CheeseArmorBootsTickEventProcedure;
import cheesemod.procedures.CheeseArmorChestplateTickEventProcedure;
import cheesemod.procedures.CheeseArmorHelmetTickEventProcedure;
import cheesemod.procedures.CheeseArmorLeggingsTickEventProcedure;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CheeseArmorItem
extends ArmorItem {
    public CheeseArmorItem(EquipmentSlotType type, Item.Properties properties) {
        super(new IArmorMaterial(){

            public int func_200896_a(EquipmentSlotType type) {
                return (new int[]{13, 15, 16, 11})[type.func_188454_b()] * 32;
            }

            public int func_200902_b(EquipmentSlotType type) {
                return (new int[]{4, 7, 10, 4})[type.func_188454_b()];
            }

            public int func_200900_a() {
                return 20;
            }

            public SoundEvent func_200899_b() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.slime_block.break"));
            }

            public Ingredient func_200898_c() {
                return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)CheesemodModItems.CHEESE.get())});
            }

            @OnlyIn(value=Dist.CLIENT)
            public String func_200897_d() {
                return "cheese_armor";
            }

            public float func_200901_e() {
                return 4.0f;
            }

            public float func_230304_f_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends CheeseArmorItem {
        public Boots() {
            super(EquipmentSlotType.FEET, new Item.Properties().func_200916_a(CheesemodModTabs.TAB_MODDED_STUFF).func_234689_a_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "cheesemod:textures/models/armor/cheese_layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, World world, PlayerEntity entity) {
            CheeseArmorBootsTickEventProcedure.execute((IWorld)world, (Entity)entity);
        }
    }

    public static class Leggings
    extends CheeseArmorItem {
        public Leggings() {
            super(EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(CheesemodModTabs.TAB_MODDED_STUFF).func_234689_a_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "cheesemod:textures/models/armor/cheese_layer_2.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, World world, PlayerEntity entity) {
            CheeseArmorLeggingsTickEventProcedure.execute((IWorld)world, (Entity)entity);
        }
    }

    public static class Chestplate
    extends CheeseArmorItem {
        public Chestplate() {
            super(EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(CheesemodModTabs.TAB_MODDED_STUFF).func_234689_a_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "cheesemod:textures/models/armor/cheese_layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, World world, PlayerEntity entity) {
            CheeseArmorChestplateTickEventProcedure.execute((IWorld)world, (Entity)entity);
        }
    }

    public static class Helmet
    extends CheeseArmorItem {
        public Helmet() {
            super(EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(CheesemodModTabs.TAB_MODDED_STUFF).func_234689_a_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "cheesemod:textures/models/armor/cheese_layer_1.png";
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void onArmorTick(ItemStack itemstack, World world, PlayerEntity entity) {
            CheeseArmorHelmetTickEventProcedure.execute((IWorld)world, (Entity)entity);
        }
    }
}

