/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.network;

import cheesemod.CheesemodMod;
import cheesemod.procedures.CheeseUpgraderBackButtonPressedProcedure;
import cheesemod.procedures.CheeseUpgraderProcedureProcedure;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CheeseUpgraderGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CheeseUpgraderGUIButtonMessage(PacketBuffer buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CheeseUpgraderGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CheeseUpgraderGUIButtonMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CheeseUpgraderGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> CheeseUpgraderGUIButtonMessage.handleButtonAction((PlayerEntity)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CheeseUpgraderProcedureProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            CheeseUpgraderBackButtonPressedProcedure.execute((IWorld)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CheesemodMod.addNetworkMessage(CheeseUpgraderGUIButtonMessage.class, CheeseUpgraderGUIButtonMessage::buffer, CheeseUpgraderGUIButtonMessage::new, CheeseUpgraderGUIButtonMessage::handler);
    }
}

