/*
 * Decompiled with CFR 0.152.
 */
package cheesemod.network;

import cheesemod.CheesemodMod;
import cheesemod.init.CheesemodModMenus;
import cheesemod.init.CheesemodModScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MenuStateUpdateMessage
implements CustomPacketPayload {
    private final int elementType;
    private final String name;
    private final Object elementState;
    public static final ResourceLocation ID = new ResourceLocation("cheesemod", "guistate_update");

    public MenuStateUpdateMessage(int elementType, String name, Object elementState) {
        this.elementType = elementType;
        this.name = name;
        this.elementState = elementState;
    }

    public MenuStateUpdateMessage(FriendlyByteBuf buffer) {
        this.elementType = buffer.readInt();
        this.name = buffer.readUtf();
        Object elementState = null;
        if (this.elementType == 0) {
            elementState = buffer.readUtf();
        } else if (this.elementType == 1) {
            elementState = buffer.readBoolean();
        }
        this.elementState = elementState;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.elementType);
        buffer.writeUtf(this.name);
        if (this.elementType == 0) {
            buffer.writeUtf((String)this.elementState);
        } else if (this.elementType == 1) {
            buffer.writeBoolean(((Boolean)this.elementState).booleanValue());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleMenuState(MenuStateUpdateMessage message, PlayPayloadContext context) {
        String string;
        Object object;
        if (message.name.length() > 256 || (object = message.elementState) instanceof String && (string = (String)object).length() > 8192) {
            return;
        }
        context.workHandler().submitAsync(() -> {
            AbstractContainerMenu patt2227$temp = ((Player)context.player().get()).containerMenu;
            if (patt2227$temp instanceof CheesemodModMenus.MenuAccessor) {
                Screen patt2455$temp;
                CheesemodModMenus.MenuAccessor menu = (CheesemodModMenus.MenuAccessor)patt2227$temp;
                menu.getMenuState().put(message.elementType + ":" + message.name, message.elementState);
                if (context.flow() == PacketFlow.CLIENTBOUND && (patt2455$temp = Minecraft.getInstance().screen) instanceof CheesemodModScreens.ScreenAccessor) {
                    CheesemodModScreens.ScreenAccessor accessor = (CheesemodModScreens.ScreenAccessor)patt2455$temp;
                    accessor.updateMenuState(message.elementType, message.name, message.elementState);
                }
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
            return null;
        });
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CheesemodMod.addNetworkMessage(ID, MenuStateUpdateMessage::new, MenuStateUpdateMessage::handleMenuState);
    }
}

