/*
 * Decompiled with CFR 0.152.
 */
package atonkish.quartzelv.gametest.testcase;

import atonkish.quartzelv.QuartzElevatorMod;
import atonkish.quartzelv.block.ModBlocks;
import atonkish.quartzelv.gametest.util.MockServerPlayerHelper;
import atonkish.quartzelv.gametest.util.TestFunction;
import atonkish.quartzelv.gametest.util.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2846;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class LootTableTests {
    private static final String TEST_ENVIRONMENT_DEFAULT = String.format("%s:loot_table/default", "quartzelv");
    private static final String TEST_STRUCTURE_EMPTY = "fabric-gametest-api-v1:empty";
    public static final Collection<TestFunction> TEST_FUNCTIONS = new ArrayList<TestFunction>(){
        {
            this.add(LootTableTests.createTest("Break Quartz Elevator with Netherite Pickaxe", ModBlocks.QUARTZ_ELEVATOR_BLOCK, class_1802.field_22024, true));
            this.add(LootTableTests.createTest("Break Quartz Elevator with Netherite Axe", ModBlocks.QUARTZ_ELEVATOR_BLOCK, class_1802.field_22025, false));
            this.add(LootTableTests.createTest("Break Quartz Elevator without tools", ModBlocks.QUARTZ_ELEVATOR_BLOCK, class_1802.field_8162, false));
            this.add(LootTableTests.createTest("Break Smooth Quartz Elevator with Netherite Pickaxe", ModBlocks.SMOOTH_QUARTZ_ELEVATOR, class_1802.field_22024, true));
            this.add(LootTableTests.createTest("Break Smooth Quartz Elevator with Netherite Axe", ModBlocks.SMOOTH_QUARTZ_ELEVATOR, class_1802.field_22025, false));
            this.add(LootTableTests.createTest("Break Smooth Quartz Elevator without tools", ModBlocks.SMOOTH_QUARTZ_ELEVATOR, class_1802.field_8162, false));
        }
    };

    private static TestFunction createTest(String name, class_2248 elevatorBlock, class_1792 tool, boolean shouldDrop) {
        class_2960 testIdentifier = TestIdentifier.of("quartzelv", LootTableTests.class, name);
        return new TestFunction(testIdentifier, TEST_ENVIRONMENT_DEFAULT, TEST_STRUCTURE_EMPTY, 1000, 0, true, class_2470.field_11467, false, 1, 1, false, context -> {
            class_2338 blockPos = class_2338.field_10980;
            context.method_35984(blockPos, elevatorBlock);
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)blockPos.method_10077(4)));
            player.method_6122(class_1268.field_5808, new class_1799((class_1935)tool));
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                player.field_13974.method_14263(context.method_36052(blockPos), class_2846.class_2847.field_12968, class_2350.field_11043, context.method_35943().method_31605(), 0);
                futurePartialAct1.complete(null);
            });
            long tickBlockBreaking = (long)Math.ceil(1.0 / (double)context.method_35980(blockPos).method_26165((class_1657)player, (class_1922)context.method_35943(), blockPos));
            context.method_35951(tickBlockBreaking, () -> {
                player.field_13974.method_14263(context.method_36052(blockPos), class_2846.class_2847.field_12973, class_2350.field_11043, context.method_35943().method_31605(), 0);
                futurePartialAct2.complete(null);
            });
            QuartzElevatorMod.LOGGER.info("[{}] {} can be mined in {} ticks by {}", new Object[]{testIdentifier, elevatorBlock.method_9518().getString(), tickBlockBreaking, tool.method_63680().getString()});
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_35972(class_2246.field_10124, blockPos);
                    context.method_44606(class_1299.field_6052, blockPos, shouldDrop ? 1 : 0, 1.0);
                }
                catch (Exception e) {
                    QuartzElevatorMod.LOGGER.error("[{}] {}", (Object)testIdentifier, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
        });
    }
}

